/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.util;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.AmbiguousType;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPThisClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class PDTTypeInferenceUtils {
    private static final IType[] EMPTY_TYPES = new IType[0];
    private static final PHPTypeInferencer TYPE_INFERENCER = new PHPTypeInferencer();

    public static IType[] getTypes(ASTNode expression, ISourceModule sourceModule) {
        IType[] types;
        IContext context = ASTUtils.findContext((ISourceModule)sourceModule, (ModuleDeclaration)SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule), (int)expression.sourceStart());
        if (context != null && (types = PDTTypeInferenceUtils.getTypes(new PHPTypeInferencer().evaluateType((AbstractTypeGoal)new ExpressionTypeGoal(context, expression)), context, expression.sourceStart())) != null) {
            return types;
        }
        return EMPTY_TYPES;
    }

    public static IType[] getTypes(IEvaluatedType evaluatedType, IContext context, int position) {
        List<IEvaluatedType> possibleTypes = new LinkedList();
        if (evaluatedType instanceof MultiTypeType) {
            possibleTypes = ((MultiTypeType)evaluatedType).getTypes();
        } else if (evaluatedType instanceof AmbiguousType) {
            possibleTypes.addAll(Arrays.asList(((AmbiguousType)evaluatedType).getPossibleTypes()));
        } else {
            possibleTypes.add(evaluatedType);
        }
        LinkedList<IType> collectingTypes = new LinkedList<IType>();
        for (IEvaluatedType possibleType : possibleTypes) {
            IType[] types = possibleType instanceof MultiTypeType || possibleType instanceof AmbiguousType ? PDTTypeInferenceUtils.getTypes(possibleType, context, position) : PHPTypeInferenceUtils.getModelElements((IEvaluatedType)possibleType, (ISourceModuleContext)((ISourceModuleContext)context), (int)position, null);
            if (types == null) continue;
            collectingTypes.addAll(Arrays.asList(types));
        }
        return collectingTypes.toArray(new IType[collectingTypes.size()]);
    }

    public static IType[] getTypes(PHPCallExpression expression, ISourceModule sourceModule) {
        IType[] receiverTypes = PDTTypeInferenceUtils.getTypes(expression.getReceiver(), sourceModule);
        if (receiverTypes != null && receiverTypes.length > 0) {
            IContext context = ASTUtils.findContext((ISourceModule)sourceModule, (ModuleDeclaration)SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule), (int)expression.sourceStart());
            return PDTTypeInferenceUtils.getFunctionReturnTypes(expression, sourceModule, receiverTypes, context);
        }
        return EMPTY_TYPES;
    }

    private static IType[] getFunctionReturnTypes(PHPCallExpression expression, ISourceModule sourceModule, IType[] receiverTypes, IContext context) {
        IEvaluatedType evaluatedType = TYPE_INFERENCER.evaluateTypePHPDoc((AbstractTypeGoal)new PHPDocMethodReturnTypeGoal(context, receiverTypes, expression.getName(), expression.sourceStart()));
        IType[] modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)evaluatedType, (ISourceModuleContext)((ISourceModuleContext)context), (int)expression.sourceStart());
        if (modelElements != null) {
            return modelElements;
        }
        evaluatedType = TYPE_INFERENCER.evaluateType((AbstractTypeGoal)new MethodElementReturnTypeGoal(context, receiverTypes, expression.getName(), new String[0], expression.sourceStart()));
        modelElements = evaluatedType instanceof PHPThisClassType && ((PHPThisClassType)evaluatedType).getType() != null ? new IType[]{((PHPThisClassType)evaluatedType).getType()} : PHPTypeInferenceUtils.getModelElements((IEvaluatedType)evaluatedType, (ISourceModuleContext)((ISourceModuleContext)context), (int)expression.sourceStart());
        if (modelElements != null) {
            return modelElements;
        }
        return EMPTY_TYPES;
    }

    private static IType[] getFunctionArrayReturnTypes(PHPCallExpression expression, ISourceModule sourceModule, IType[] receiverTypes, IContext context) {
        IEvaluatedType evaluatedType = TYPE_INFERENCER.evaluateTypePHPDoc((AbstractTypeGoal)new PHPDocMethodReturnTypeGoal(context, receiverTypes, expression.getName(), expression.sourceStart()));
        if (evaluatedType instanceof MultiTypeType) {
            LinkedList<IType> collectingTypes = new LinkedList<IType>();
            for (IEvaluatedType possibleType : ((MultiTypeType)evaluatedType).getTypes()) {
                IType[] types = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)possibleType, (ISourceModuleContext)((ISourceModuleContext)context), (int)expression.sourceStart(), null);
                if (types == null) continue;
                collectingTypes.addAll(Arrays.asList(types));
            }
            return collectingTypes.toArray(new IType[collectingTypes.size()]);
        }
        evaluatedType = TYPE_INFERENCER.evaluateType((AbstractTypeGoal)new MethodElementReturnTypeGoal(context, receiverTypes, expression.getName(), new String[0], expression.sourceStart()));
        if (evaluatedType instanceof MultiTypeType) {
            LinkedList<IType> collectingTypes = new LinkedList<IType>();
            for (IEvaluatedType possibleType : ((MultiTypeType)evaluatedType).getTypes()) {
                IType[] types = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)possibleType, (ISourceModuleContext)((ISourceModuleContext)context), (int)expression.sourceStart(), null);
                if (types == null) continue;
                collectingTypes.addAll(Arrays.asList(types));
            }
            return collectingTypes.toArray(new IType[collectingTypes.size()]);
        }
        return EMPTY_TYPES;
    }
}

