/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.repos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.pdtextensions.repos.FindResult;
import org.pdtextensions.repos.PEXReposPlugin;
import org.pdtextensions.repos.api.IFindResult;
import org.pdtextensions.repos.api.IModule;
import org.pdtextensions.repos.api.IModuleVersion;
import org.pdtextensions.repos.api.IRepositoryProvider;

public class Module
implements IModule {
    private String name;
    private String vendor;
    private IRepositoryProvider provider;
    private Map<String, IModuleVersion> versions = new HashMap<String, IModuleVersion>();
    private IModuleVersion newestRelease;
    private IModuleVersion newestSnapshot;

    public Module(String name, String vendor, IRepositoryProvider provider, IModuleVersion[] versions, String newestRelease, String newestSnapshot) {
        this.name = name;
        this.vendor = vendor;
        this.provider = provider;
        this.versions = new HashMap<String, IModuleVersion>();
        IModuleVersion[] iModuleVersionArray = versions;
        int n = versions.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleVersion version = iModuleVersionArray[n2];
            this.versions.put(version.getName().toLowerCase(), version);
            ++n2;
        }
        if (newestRelease != null) {
            this.newestRelease = this.versions.get(newestRelease.toLowerCase());
        }
        if (newestSnapshot != null) {
            this.newestSnapshot = this.versions.get(newestSnapshot.toLowerCase());
        }
    }

    protected Module(String name, String vendor, IRepositoryProvider provider) {
        this.name = name;
        this.vendor = vendor;
        this.provider = provider;
    }

    protected Map<String, IModuleVersion> loadVersions() throws CoreException {
        return null;
    }

    protected String loadNewestReleaseVersion() throws CoreException {
        return null;
    }

    protected String loadNewestSnapshotVersion() throws CoreException {
        return null;
    }

    private void init() throws CoreException {
        if (this.versions == null) {
            this.versions = this.loadVersions();
            String devV = this.loadNewestSnapshotVersion();
            String relV = this.loadNewestReleaseVersion();
            if (devV != null) {
                this.newestSnapshot = this.versions.get(devV.toLowerCase());
            }
            if (relV != null) {
                this.newestRelease = this.versions.get(relV.toLowerCase());
            }
        }
    }

    @Override
    public IRepositoryProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getVendorName() {
        return this.vendor;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IFindResult findVersion(String version, IProgressMonitor monitor) {
        try {
            this.init();
        }
        catch (CoreException e) {
            return new FindResult((IStatus)new Status(4, "org.pdtextensions.repos", "error loading versions", (Throwable)e), Collections.EMPTY_LIST);
        }
        String searchVersion = version == null ? ".*" : PEXReposPlugin.maskSearchStringToRegexp(version);
        Pattern patternVersion = Pattern.compile(searchVersion);
        ArrayList<IModuleVersion> result = new ArrayList<IModuleVersion>();
        for (Map.Entry<String, IModuleVersion> v : this.versions.entrySet()) {
            if (!patternVersion.matcher(v.getKey()).matches()) continue;
            result.add(v.getValue());
        }
        return new FindResult(Status.OK_STATUS, result);
    }

    @Override
    public IFindResult findReleaseVersion(String version, IProgressMonitor monitor) {
        try {
            this.init();
        }
        catch (CoreException e) {
            return new FindResult((IStatus)new Status(4, "org.pdtextensions.repos", "error loading versions", (Throwable)e), Collections.EMPTY_LIST);
        }
        String searchVersion = version == null ? ".*" : PEXReposPlugin.maskSearchStringToRegexp(version);
        Pattern patternVersion = Pattern.compile(searchVersion);
        ArrayList<IModuleVersion> result = new ArrayList<IModuleVersion>();
        for (Map.Entry<String, IModuleVersion> v : this.versions.entrySet()) {
            if (!patternVersion.matcher(v.getKey()).matches() || !v.getValue().isDevelopment()) continue;
            result.add(v.getValue());
        }
        return new FindResult(Status.OK_STATUS, result);
    }

    @Override
    public IFindResult findDevVersion(String version, IProgressMonitor monitor) {
        try {
            this.init();
        }
        catch (CoreException e) {
            return new FindResult((IStatus)new Status(4, "org.pdtextensions.repos", "error loading versions", (Throwable)e), Collections.EMPTY_LIST);
        }
        String searchVersion = version == null ? ".*" : PEXReposPlugin.maskSearchStringToRegexp(version);
        Pattern patternVersion = Pattern.compile(searchVersion);
        ArrayList<IModuleVersion> result = new ArrayList<IModuleVersion>();
        for (Map.Entry<String, IModuleVersion> v : this.versions.entrySet()) {
            if (!patternVersion.matcher(v.getKey()).matches() || !v.getValue().isRelease()) continue;
            result.add(v.getValue());
        }
        return new FindResult(Status.OK_STATUS, result);
    }

    @Override
    public Iterable<IModuleVersion> listReleaseVersions(IProgressMonitor monitor) throws CoreException {
        this.init();
        ArrayList<IModuleVersion> result = new ArrayList<IModuleVersion>();
        for (IModuleVersion v : this.versions.values()) {
            if (!v.isRelease()) continue;
            result.add(v);
        }
        return result;
    }

    @Override
    public Iterable<IModuleVersion> listDevVersions(IProgressMonitor monitor) throws CoreException {
        this.init();
        ArrayList<IModuleVersion> result = new ArrayList<IModuleVersion>();
        for (IModuleVersion v : this.versions.values()) {
            if (!v.isDevelopment()) continue;
            result.add(v);
        }
        return result;
    }

    @Override
    public Iterable<IModuleVersion> listVersions(IProgressMonitor monitor) throws CoreException {
        this.init();
        return new ArrayList<IModuleVersion>(this.versions.values());
    }

    @Override
    public IModuleVersion getNewestReleaseVersion(IProgressMonitor monitor) throws CoreException {
        this.init();
        return this.newestRelease;
    }

    @Override
    public IModuleVersion getNewestDevVersion(IProgressMonitor monitor) throws CoreException {
        this.init();
        return this.newestSnapshot;
    }
}

