/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.repos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.pdtextensions.repos.api.IRepositoryProvider;
import org.pdtextensions.repos.api.IRepositoryProviderFactory;
import org.pdtextensions.repos.internal.wrapper.GlobalRepositoryProvider;

public class PEXReposPlugin
implements BundleActivator {
    public static final String PLUGIN_ID = "org.pdtextensions.repos";
    private static PEXReposPlugin plugin;
    private static BundleContext context;
    private static List<IRepositoryProviderFactory> FACTORIES;
    private static GlobalRepositoryProvider GLOBAL_PROVIDER;
    private static int nextId;

    static {
        nextId = 0;
    }

    static BundleContext getContext() {
        return context;
    }

    public static PEXReposPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        PEXReposPlugin.init();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        FACTORIES = null;
        plugin = null;
        GLOBAL_PROVIDER = null;
        context = null;
    }

    private static void init() {
        if (FACTORIES == null) {
            FACTORIES = new ArrayList<IRepositoryProviderFactory>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.pdtextensions.repos.factories");
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    FACTORIES.add((IRepositoryProviderFactory)element.createExecutableExtension("class"));
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++n2;
            }
            GLOBAL_PROVIDER = new GlobalRepositoryProvider();
        }
    }

    public static IRepositoryProvider getProvider() {
        PEXReposPlugin.init();
        return GLOBAL_PROVIDER;
    }

    public static Iterable<IRepositoryProvider> getProviders() {
        PEXReposPlugin.init();
        return GLOBAL_PROVIDER.getProviders();
    }

    public static IRepositoryProvider createProvider(String type, String uri) throws CoreException {
        PEXReposPlugin.init();
        for (IRepositoryProviderFactory factory : FACTORIES) {
            if (!type.equals(factory.getType())) continue;
            return factory.createTemporary(uri, "temp-" + ++nextId);
        }
        throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Cannot create repository; type not found."));
    }

    public static void registerProvider(IRepositoryProvider provider) {
        PEXReposPlugin.init();
        GLOBAL_PROVIDER.registerProvider(provider);
    }

    public static void unregisterProvider(IRepositoryProvider provider) {
        PEXReposPlugin.init();
        GLOBAL_PROVIDER.unregisterProvider(provider);
    }

    public static Iterable<IRepositoryProviderFactory> getFactories() {
        PEXReposPlugin.init();
        return Collections.unmodifiableList(FACTORIES);
    }

    public static String maskSearchStringToRegexp(String searchString) {
        return searchString.toLowerCase().replace("\\", "\\\\").replace(".", "\\.").replace("[", "\\[").replace("]", "\\]").replace("^", "\\^").replace("$", "\\$").replace("|", "\\|").replace("?", "\\?").replace("+", "\\+").replace("(", "\\(").replace(")", "\\)").replace("*", ".*");
    }

    public static boolean debug() {
        String debugOption = Platform.getDebugOption((String)"org.pdtextensions.repos/debug");
        return "true".equalsIgnoreCase(debugOption);
    }
}

