/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.repos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.pdtextensions.repos.FindResult;
import org.pdtextensions.repos.PEXReposPlugin;
import org.pdtextensions.repos.api.IFindResult;
import org.pdtextensions.repos.api.IModule;
import org.pdtextensions.repos.api.IModuleVersion;
import org.pdtextensions.repos.api.IVendor;
import org.pdtextensions.repos.api.IVendorAwareProvider;

public class Vendor
implements IVendor {
    private Map<String, IModule> modules;
    private String name;
    private IVendorAwareProvider provider;

    protected Vendor(String name, IVendorAwareProvider provider) {
        this.name = name;
        this.provider = provider;
    }

    public Vendor(String name, IVendorAwareProvider provider, IModule[] modules) {
        this.name = name;
        this.provider = provider;
        this.modules = new HashMap<String, IModule>();
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            this.modules.put(module.getName().toLowerCase(), module);
            ++n2;
        }
    }

    protected Map<String, IModule> loadModules() throws CoreException {
        return null;
    }

    private void init() throws CoreException {
        if (this.modules == null) {
            this.modules = this.loadModules();
        }
    }

    @Override
    public IVendorAwareProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IFindResult findModule(String name, String version, IProgressMonitor monitor) {
        try {
            this.init();
        }
        catch (CoreException e) {
            return new FindResult((IStatus)new Status(4, "org.pdtextensions.repos", "error loading modules", (Throwable)e), Collections.EMPTY_LIST);
        }
        String searchName = name == null ? ".*" : PEXReposPlugin.maskSearchStringToRegexp(name);
        String searchVersion = version == null ? "*" : version;
        Pattern patternName = Pattern.compile(searchName);
        ArrayList<IModuleVersion> result = new ArrayList<IModuleVersion>();
        for (Map.Entry<String, IModule> module : this.modules.entrySet()) {
            if (monitor.isCanceled()) break;
            if (!patternName.matcher(module.getKey().toLowerCase()).matches()) continue;
            IFindResult findResult = module.getValue().findVersion(searchVersion, monitor);
            if (!findResult.isOk()) {
                return findResult;
            }
            for (IModuleVersion v : findResult.moduleVersions()) {
                result.add(v);
            }
        }
        return new FindResult(Status.OK_STATUS, result);
    }

    @Override
    public Iterable<IModule> listModules(IProgressMonitor monitor) throws CoreException {
        this.init();
        return new ArrayList<IModule>(this.modules.values());
    }
}

