/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server.ui.internal.lhttpd;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.pdtextensions.server.IPEXInstallableRuntime;
import org.pdtextensions.server.PEXServerPlugin;
import org.pdtextensions.server.lhttpd.ILHttpdRuntimeWorkingCopy;
import org.pdtextensions.server.ui.internal.lhttpd.Messages;
import org.pdtextensions.server.ui.internal.lhttpd.SWTUtil;

public class LHttpdRuntimeComposite
extends Composite {
    private IWizardHandle wizard;
    private IRuntimeWorkingCopy runtimeWC;
    private ILHttpdRuntimeWorkingCopy runtime;
    private IPEXInstallableRuntime ir;
    protected Label installLabel;
    protected Button install;
    private Text name;
    private Text installDir;
    private Job installRuntimeJob;
    private JobChangeAdapter jobListener;

    public LHttpdRuntimeComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.LHttpdRuntimeComposite_Title);
        wizard.setDescription(Messages.LHttpdRuntimeComposite_Description);
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.LHttpdRuntimeComposite_Name);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LHttpdRuntimeComposite.this.runtimeWC.setName(LHttpdRuntimeComposite.this.name.getText());
                LHttpdRuntimeComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.LHttpdRuntimeComposite_InstallDir);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.installDir = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.installDir.setLayoutData((Object)data);
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LHttpdRuntimeComposite.this.runtimeWC.setLocation((IPath)new Path(LHttpdRuntimeComposite.this.installDir.getText()));
                LHttpdRuntimeComposite.this.validate();
            }
        });
        Button browse = SWTUtil.createButton(this, Messages.LHttpdRuntimeComposite_Browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(LHttpdRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.LHttpdRuntimeComposite_SelectApacheXamppInstallDir);
                dialog.setFilterPath(LHttpdRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    LHttpdRuntimeComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        this.installLabel = new Label((Composite)this, 131072);
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.installLabel.setLayoutData((Object)data);
        this.install = SWTUtil.createButton(this, Messages.LHttpdRuntimeComposite_Install);
        this.install.setEnabled(false);
        this.install.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String license = null;
                try {
                    license = LHttpdRuntimeComposite.this.ir.getLicense((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    PEXServerPlugin.logError((String)"Error getting license", (Throwable)e);
                }
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("license", (Object)license);
                TaskWizard wizard2 = new TaskWizard(Messages.LHttpdRuntimeComposite_TitleDownloadAndInstall, new WizardFragment(){

                    protected void createChildFragments(List<WizardFragment> list) {
                        list.add((WizardFragment)new LicenseWizardFragment());
                    }
                }, taskModel);
                WizardDialog dialog2 = new WizardDialog(LHttpdRuntimeComposite.this.getShell(), (IWizard)wizard2);
                if (dialog2.open() == 1) {
                    return;
                }
                DirectoryDialog dialog = new DirectoryDialog(LHttpdRuntimeComposite.this.getShell());
                dialog.setMessage(Messages.LHttpdRuntimeComposite_SelectXamppInstallDir);
                dialog.setFilterPath(LHttpdRuntimeComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    Path installPath = new Path(selectedDirectory);
                    LHttpdRuntimeComposite.this.installRuntimeJob = new Job(Messages.LHttpdRuntimeComposite_TaskInstallingRuntime, (IPath)installPath){
                        private final /* synthetic */ IPath val$installPath;
                        {
                            this.val$installPath = iPath;
                            super($anonymous0);
                        }

                        public boolean belongsTo(Object family) {
                            return "org.pdtextensions.server.ui".equals(family);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                LHttpdRuntimeComposite.this.ir.install(this.val$installPath, monitor);
                            }
                            catch (CoreException ce) {
                                return ce.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    LHttpdRuntimeComposite.this.installDir.setText(selectedDirectory);
                    LHttpdRuntimeComposite.this.jobListener = new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            LHttpdRuntimeComposite.this.installRuntimeJob.removeJobChangeListener((IJobChangeListener)this);
                            LHttpdRuntimeComposite.this.installRuntimeJob = null;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!LHttpdRuntimeComposite.this.isDisposed()) {
                                        LHttpdRuntimeComposite.this.validate();
                                    }
                                }
                            });
                        }
                    };
                    LHttpdRuntimeComposite.this.installRuntimeJob.addJobChangeListener((IJobChangeListener)LHttpdRuntimeComposite.this.jobListener);
                    LHttpdRuntimeComposite.this.installRuntimeJob.schedule();
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.installRuntimeJob != null) {
            this.installRuntimeJob.removeJobChangeListener((IJobChangeListener)this.jobListener);
        }
    }

    public void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (ILHttpdRuntimeWorkingCopy)newRuntime.loadAdapter(ILHttpdRuntimeWorkingCopy.class, null);
        }
        this.install.setEnabled(false);
        this.installLabel.setText("");
        if (this.runtimeWC == null) {
            this.ir = null;
        } else {
            this.ir = this.runtime.getInstallableRuntime();
            if (this.ir != null) {
                this.install.setEnabled(true);
                this.installLabel.setText(this.ir.getName());
            }
        }
        this.init();
        this.validate();
    }

    protected void init() {
        if (this.name == null || this.runtime == null) {
            return;
        }
        if (this.runtimeWC.getName() != null) {
            this.name.setText(this.runtimeWC.getName());
        } else {
            this.name.setText("");
        }
        if (this.runtimeWC.getLocation() != null) {
            this.installDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }
}

