/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server.ui.internal.web;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.pdtextensions.server.PEXServerPlugin;
import org.pdtextensions.server.ui.internal.lhttpd.SWTUtil;
import org.pdtextensions.server.ui.internal.web.Messages;
import org.pdtextensions.server.web.IPhpWebFolder;
import org.pdtextensions.server.web.IPhpWebProject;

public class ProjectPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected IPhpWebProject project;
    private Text htdocs;
    private Button browse;
    private WebRootsList webRoots;
    private List<IPhpWebFolder> removedFolders = new ArrayList<IPhpWebFolder>();

    protected Control createContents(Composite parent) {
        IAdaptable element = this.getElement();
        IProject p = (IProject)element.getAdapter(IProject.class);
        try {
            this.project = PEXServerPlugin.create((IProject)p);
        }
        catch (CoreException e) {
            PEXServerPlugin.logError((Throwable)e);
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite composite2 = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 5;
        composite2.setLayout((Layout)layout);
        composite2.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite2, 64);
        label.setText(Messages.ProjectPropertyPage_LabelHtdocsFolder);
        GridData data = new GridData(0);
        data.widthHint = 200;
        label.setLayoutData((Object)data);
        this.htdocs = new Text(composite2, 0);
        data = new GridData(768);
        this.htdocs.setLayoutData((Object)data);
        this.htdocs.setEditable(false);
        this.htdocs.setText(this.project.getDefaultWebFolder().getProjectRelativePath().toString());
        this.browse = SWTUtil.createButton(composite2, Messages.ProjectPropertyPage_Browse);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IResource resource;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(ProjectPropertyPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ProjectContentProvider());
                dialog.setTitle(Messages.ProjectPropertyPage_SelectHtdocsFolderTitle);
                dialog.setMessage(Messages.ProjectPropertyPage_SelectHtdocsFolderDescription);
                dialog.setInput((Object)ProjectPropertyPage.this.project.getEclipseProject().getWorkspace());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setInitialSelection((Object)ProjectPropertyPage.this.project.getDefaultWebFolder());
                dialog.setAllowMultiple(false);
                if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                    ProjectPropertyPage.this.htdocs.setText(resource.getProjectRelativePath().toString());
                    ProjectPropertyPage.this.validate();
                }
            }
        });
        this.webRoots = new WebRootsList(composite, 0);
        data = new GridData(1808);
        this.webRoots.setLayoutData(data);
        this.validate();
        return composite;
    }

    private void validate() {
        IFolder htdocs;
        this.setErrorMessage(null);
        if (!(this.htdocs.getText().length() <= 0 || (htdocs = this.project.getEclipseProject().getFolder(this.htdocs.getText())).isAccessible() && htdocs.exists())) {
            this.setErrorMessage(NLS.bind((String)Messages.ProjectPropertyPage_ErrorHtdocsDoesNotExist, (Object)this.htdocs.getText()));
            return;
        }
        HashSet<String> paths = new HashSet<String>();
        TableItem[] tableItemArray = this.webRoots.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            WebRootItem item = (WebRootItem)tableItem.getData();
            if (!item.getPathName().startsWith("/")) {
                this.setErrorMessage(NLS.bind((String)Messages.ProjectPropertyPage_ErrorPathMustStartWithSlash, (Object)item.getPathName()));
                return;
            }
            if (paths.contains(item.getPathName())) {
                this.setErrorMessage(NLS.bind((String)Messages.ProjectPropertyPage_ErrorDuplicatePath, (Object)item.getPathName()));
                return;
            }
            paths.add(item.getPathName());
            if (!item.getFolder().exists()) {
                this.setErrorMessage(NLS.bind((String)Messages.ProjectPropertyPage_ErrorHtdocsDoesNotExist, (Object)item.getFolder().getProjectRelativePath().toString()));
                return;
            }
            ++n2;
        }
    }

    protected void performDefaults() {
        this.htdocs.setText("");
        this.removedFolders.clear();
        IPhpWebFolder[] iPhpWebFolderArray = this.project.getWebFolders();
        int n = iPhpWebFolderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPhpWebFolder folder = iPhpWebFolderArray[n2];
            this.removedFolders.add(folder);
            ++n2;
        }
        this.webRoots.table.removeAll();
        this.validate();
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            this.project.setDefaultWebFolder((IContainer)(this.htdocs.getText().length() > 0 ? this.project.getEclipseProject().getFolder(this.htdocs.getText()) : this.project.getEclipseProject()));
            for (IPhpWebFolder folder : this.removedFolders) {
                this.project.removeWebFolder(folder);
            }
            TableItem[] tableItemArray = this.webRoots.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                WebRootItem item = (WebRootItem)tableItem.getData();
                if (item.isNew()) {
                    this.project.createWebFolder(item.getFolder(), item.getPathName());
                } else if (item.isChanged()) {
                    item.getWebFolder().set(item.getFolder(), item.getPathName());
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            PEXServerPlugin.logError((Throwable)ex);
        }
        return super.performOk();
    }

    private final class ProjectContentProvider
    extends WorkbenchContentProvider {
        private ProjectContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                return new Object[]{ProjectPropertyPage.this.project.getEclipseProject()};
            }
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = super.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object elm = objectArray[n2];
                if (elm instanceof IFolder) {
                    result.add(elm);
                }
                ++n2;
            }
            return result.toArray();
        }
    }

    private final class WebRootItem {
        private IPhpWebFolder webFolder;
        private boolean changed;
        private String pathName;
        private IContainer folder;

        public WebRootItem(String pathName, IContainer folder) {
            this.pathName = pathName;
            this.folder = folder;
        }

        public WebRootItem(IPhpWebFolder folder) {
            this.webFolder = folder;
            this.pathName = folder.getPathName();
            this.folder = folder.getFolder();
        }

        public void setPathName(String pathName) {
            this.pathName = pathName;
            this.changed = true;
        }

        public void setFolder(IContainer folder) {
            this.folder = folder;
            this.changed = true;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isNew() {
            return this.webFolder == null;
        }

        public String getPathName() {
            return this.pathName;
        }

        public IContainer getFolder() {
            return this.folder;
        }

        public IPhpWebFolder getWebFolder() {
            return this.webFolder;
        }
    }

    private final class WebRootsList
    extends Composite {
        private Table table;
        private Button browseButton;
        private Button addButton;
        private Button removeButton;
        private TableEditor tableEditor;

        public WebRootsList(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            this.table = new Table((Composite)this, 268436228);
            this.table.setHeaderVisible(true);
            IPhpWebFolder[] iPhpWebFolderArray = ProjectPropertyPage.this.project.getWebFolders();
            int n = iPhpWebFolderArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPhpWebFolder folder = iPhpWebFolderArray[n2];
                TableItem item = new TableItem(this.table, 0);
                WebRootItem rootItem = new WebRootItem(folder);
                item.setText(0, rootItem.getPathName());
                item.setText(1, rootItem.getFolder().getProjectRelativePath().toString());
                item.setData((Object)rootItem);
                ++n2;
            }
            TableLayout tableLayout = new TableLayout();
            GridData data = new GridData(1808);
            this.table.setLayoutData((Object)data);
            TableColumn col = new TableColumn(this.table, 0);
            col.setText(Messages.ProjectPropertyPage_TablePathName);
            ColumnWeightData colData = new ColumnWeightData(10, 100, true);
            tableLayout.addColumnData((ColumnLayoutData)colData);
            col = new TableColumn(this.table, 0);
            col.setText(Messages.ProjectPropertyPage_TableHtdocsFolder);
            colData = new ColumnWeightData(10, 100, true);
            tableLayout.addColumnData((ColumnLayoutData)colData);
            this.table.setLayout((Layout)tableLayout);
            this.tableEditor = new TableEditor(this.table);
            this.tableEditor.horizontalAlignment = 16384;
            this.tableEditor.grabHorizontal = true;
            this.tableEditor.minimumWidth = 50;
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = WebRootsList.this.table.getSelectionCount() == 1;
                    WebRootsList.this.browseButton.setEnabled(enabled);
                    WebRootsList.this.removeButton.setEnabled(enabled);
                    Control oldEditor = WebRootsList.this.tableEditor.getEditor();
                    if (oldEditor != null) {
                        oldEditor.dispose();
                    }
                    if (enabled) {
                        TableItem item = WebRootsList.this.table.getSelection()[0];
                        Text newEditor = new Text((Composite)WebRootsList.this.table, 0);
                        newEditor.setText(item.getText(0));
                        newEditor.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                Text text = (Text)WebRootsList.this.tableEditor.getEditor();
                                String value = text.getText();
                                if (!value.startsWith("/")) {
                                    value = "/" + value;
                                }
                                WebRootsList.this.tableEditor.getItem().setText(0, value);
                                ((WebRootItem)WebRootsList.this.tableEditor.getItem().getData()).setPathName(value);
                                ProjectPropertyPage.this.validate();
                            }
                        });
                        newEditor.selectAll();
                        newEditor.setFocus();
                        WebRootsList.this.tableEditor.setEditor((Control)newEditor, item, 0);
                    }
                }
            });
            Composite composite = new Composite((Composite)this, 0);
            data = new GridData(1040);
            composite.setLayoutData((Object)data);
            composite.setLayout((Layout)new GridLayout(1, false));
            this.browseButton = SWTUtil.createButton(composite, Messages.ProjectPropertyPage_Browse);
            this.browseButton.setEnabled(false);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IResource resource;
                    if (WebRootsList.this.table.getSelection() == null || WebRootsList.this.table.getSelection().length == 0) {
                        return;
                    }
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(WebRootsList.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ProjectContentProvider());
                    TableItem item = WebRootsList.this.table.getSelection()[0];
                    dialog.setTitle(Messages.ProjectPropertyPage_SelectHtdocsFolderTitle);
                    dialog.setMessage(Messages.ProjectPropertyPage_SelectHtdocsFolderDescription);
                    dialog.setInput((Object)((WebRootsList)WebRootsList.this).ProjectPropertyPage.this.project.getEclipseProject().getWorkspace());
                    dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                    dialog.setInitialSelection((Object)((WebRootItem)item.getData()).getFolder());
                    dialog.setAllowMultiple(false);
                    if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                        ((WebRootItem)item.getData()).setFolder((IContainer)resource);
                        item.setText(1, resource.getProjectRelativePath().toString());
                        ProjectPropertyPage.this.validate();
                    }
                }
            });
            this.addButton = SWTUtil.createButton(composite, Messages.ProjectPropertyPage_Add);
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IResource resource;
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(WebRootsList.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new ProjectContentProvider());
                    dialog.setTitle(Messages.ProjectPropertyPage_SelectHtdocsFolderTitle);
                    dialog.setMessage(Messages.ProjectPropertyPage_SelectHtdocsFolderDescription);
                    dialog.setInput((Object)((WebRootsList)WebRootsList.this).ProjectPropertyPage.this.project.getEclipseProject().getWorkspace());
                    dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                    dialog.setAllowMultiple(false);
                    if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                        TableItem item = new TableItem(WebRootsList.this.table, 0);
                        WebRootItem rootItem = new WebRootItem("/" + resource.getProjectRelativePath().toString(), (IContainer)resource);
                        item.setText(0, rootItem.getPathName());
                        item.setText(1, rootItem.getFolder().getProjectRelativePath().toString());
                        item.setData((Object)rootItem);
                        ProjectPropertyPage.this.validate();
                    }
                }
            });
            this.removeButton = SWTUtil.createButton(composite, Messages.ProjectPropertyPage_Remove);
            this.removeButton.setEnabled(false);
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WebRootsList.this.table.getSelection() == null || WebRootsList.this.table.getSelection().length == 0) {
                        return;
                    }
                    TableItem item = WebRootsList.this.table.getSelection()[0];
                    if (!((WebRootItem)item.getData()).isNew()) {
                        ProjectPropertyPage.this.removedFolders.add(((WebRootItem)item.getData()).getWebFolder());
                    }
                    int i = 0;
                    while (i < WebRootsList.this.table.getItemCount()) {
                        if (WebRootsList.this.table.getItem(i) == item) {
                            WebRootsList.this.table.remove(i);
                            break;
                        }
                        ++i;
                    }
                    ProjectPropertyPage.this.validate();
                }
            });
        }
    }
}

