/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.pdtextensions.server.internal.web.PhpWebProject;
import org.pdtextensions.server.web.IPhpWebProject;

public class PEXServerPlugin
extends Plugin
implements BundleActivator {
    private static BundleContext context;
    private static PEXServerPlugin plugin;
    public static final String PLUGIN_ID = "org.pdtextensions.server";
    private static Map<IProject, PhpWebProject> webProjects;
    private static IResourceChangeListener projectListener;

    static {
        webProjects = new HashMap<IProject, PhpWebProject>();
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        plugin = null;
        webProjects.clear();
        if (projectListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(projectListener);
            projectListener = null;
        }
    }

    public static String getPreference(String id) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).get(id, null);
    }

    public static void setPreference(String id, String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        prefs.put(id, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PEXServerPlugin.logError(e);
        }
    }

    public static void logError(Throwable t) {
        if (plugin != null) {
            Status status = new Status(4, PLUGIN_ID, "Exception occurred", t);
            plugin.getLog().log((IStatus)status);
        }
    }

    public static void logError(String message, Throwable t) {
        if (plugin != null) {
            Status status = new Status(4, PLUGIN_ID, message, t);
            plugin.getLog().log((IStatus)status);
        }
    }

    public static synchronized IPhpWebProject create(IProject project) throws CoreException {
        PhpWebProject webProject;
        if (projectListener == null) {
            projectListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta;
                    if (event.getType() == 2 && event.getResource() instanceof IResource) {
                        PhpWebProject webProject = (PhpWebProject)webProjects.get((IProject)event.getResource());
                        if (webProject != null) {
                            webProject.notifyProjectClosed();
                            webProjects.remove((IProject)event.getResource());
                        }
                    } else if (event.getType() == 1 && (delta = event.getDelta()) != null) {
                        for (PhpWebProject project : webProjects.values()) {
                            IResourceDelta settingsDelta = delta.findMember(project.getEclipseProject().getFile(".settings/org.pdtextensions.server.webproject.prefs").getFullPath());
                            if (settingsDelta == null) continue;
                            project.notifySettingsChanged();
                        }
                    }
                }
            };
            ResourcesPlugin.getWorkspace().addResourceChangeListener(projectListener, 3);
        }
        if ((webProject = webProjects.get(project)) == null) {
            if (PHPFacets.isFacetedProject((IProject)project)) {
                webProject = new PhpWebProject(project);
                webProjects.put(project, webProject);
            } else {
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Given project is not a php faceted project"));
            }
        }
        return webProject;
    }
}

