/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server.internal.lhttpd;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.core.helpers.TarEntry;
import org.eclipse.equinox.internal.p2.core.helpers.TarException;
import org.eclipse.equinox.internal.p2.core.helpers.TarInputStream;
import org.eclipse.osgi.util.NLS;
import org.pdtextensions.server.IPEXInstallableRuntime;
import org.pdtextensions.server.internal.lhttpd.Messages;

public abstract class InstallableRuntime2
implements IPEXInstallableRuntime {
    private byte[] BUFFER = null;
    private int DEFAULT_DOWNLOAD_SIZE = 10000000;
    private int DEFAULT_FILE_COUNT = 1000;

    public abstract String getArchiveUrl();

    public abstract String getArchivePath();

    public int getArchiveSize() {
        return -1;
    }

    public int getFileCount() {
        return -1;
    }

    public abstract String getLicenseURL();

    @Override
    public String getLicense(IProgressMonitor monitor) throws CoreException {
        String string;
        URL url = null;
        ByteArrayOutputStream out = null;
        try {
            String licenseURL = this.getLicenseURL();
            if (licenseURL == null) {
                return null;
            }
            url = new URL(licenseURL);
            InputStream in = url.openStream();
            out = new ByteArrayOutputStream();
            this.copyWithSize(in, out, null, 0);
            string = new String(out.toByteArray());
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", 0, NLS.bind((String)Messages.InstallableRuntime2_ErrorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    @Override
    public void install(final IPath path) {
        Job installRuntimeJob = new Job(NLS.bind((String)Messages.InstallableRuntime2_TaskInstallRuntime, (Object)this.getName())){

            public boolean belongsTo(Object family) {
                return "org.pdtextensions.server".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    InstallableRuntime2.this.install(path, monitor);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        installRuntimeJob.schedule();
    }

    private void copyWithSize(InputStream in, OutputStream out, IProgressMonitor monitor, int size) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)size);
        int r = in.read(this.BUFFER);
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            progress.worked(r);
            r = in.read(this.BUFFER);
        }
    }

    private void download(InputStream in, OutputStream out, IProgressMonitor monitor, String name, int size) throws IOException {
        if (this.BUFFER == null) {
            this.BUFFER = new byte[8192];
        }
        String msg = NLS.bind((String)(size > 0 ? Messages.InstallableRuntime2_DownloadKnownSize : Messages.InstallableRuntime2_DownloadUnknownSize), (Object[])new Object[]{name, "{0}", Integer.toString(size / 1024)});
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)msg, (Object)"0"), (int)(size > 0 ? size : this.DEFAULT_DOWNLOAD_SIZE));
        int r = in.read(this.BUFFER);
        int total = 0;
        int lastTotal = 0;
        while (r >= 0) {
            out.write(this.BUFFER, 0, r);
            if ((total += r) >= lastTotal + 8192) {
                lastTotal = total;
                progress.subTask(NLS.bind((String)msg, (Object)Integer.toString(lastTotal / 1024)));
            }
            progress.worked(r);
            if (size <= 0) {
                progress.setWorkRemaining(this.DEFAULT_DOWNLOAD_SIZE);
            }
            if (progress.isCanceled()) break;
            r = in.read(this.BUFFER);
        }
    }

    @Override
    public void install(IPath path, IProgressMonitor monitor) throws CoreException {
        InputStream in;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        URL url = null;
        File temp = null;
        try {
            url = new URL(this.getArchiveUrl());
            temp = File.createTempFile("runtime", "");
            temp.deleteOnExit();
        }
        catch (IOException e) {
            if (monitor != null) {
                monitor.done();
            }
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", 0, NLS.bind((String)Messages.InstallableRuntime2_ErrorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
        }
        String name = url.getQuery();
        int archiveSize = this.getArchiveSize();
        FileOutputStream fout = null;
        try {
            try {
                in = url.openStream();
                fout = new FileOutputStream(temp);
                this.download(in, fout, (IProgressMonitor)progress.newChild(500), name, archiveSize);
                progress.setWorkRemaining(500);
            }
            catch (Exception e) {
                if (monitor != null) {
                    monitor.done();
                }
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", 0, NLS.bind((String)Messages.InstallableRuntime2_ErrorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (progress.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        in = null;
        try {
            try {
                in = new FileInputStream(temp);
                if (name.endsWith("zip")) {
                    this.unzip(in, path, (IProgressMonitor)progress.newChild(500));
                } else if (name.endsWith("tar")) {
                    this.untar(in, path, (IProgressMonitor)progress.newChild(500));
                } else if (name.endsWith("tar.gz")) {
                    File tarFile = File.createTempFile("runtime", ".tar");
                    tarFile.deleteOnExit();
                    String tarName = name;
                    progress.subTask(NLS.bind((String)Messages.InstallableRuntime2_TaskUncompressing, (Object)tarName));
                    int tempSize = Integer.MAX_VALUE;
                    if (temp.length() < Integer.MAX_VALUE) {
                        tempSize = (int)temp.length();
                    }
                    this.ungzip(in, tarFile, (IProgressMonitor)progress.newChild(250), tempSize);
                    progress.setWorkRemaining(250);
                    if (!progress.isCanceled()) {
                        in = new FileInputStream(tarFile);
                        this.untar(in, path, (IProgressMonitor)progress.newChild(250));
                    }
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", 0, NLS.bind((String)Messages.InstallableRuntime2_ErrorInstallingServer, (Object)e.getLocalizedMessage()), (Throwable)e));
            }
        }
        finally {
            try {
                if (in != null) {
                    ((FileInputStream)in).close();
                }
            }
            catch (IOException iOException) {}
            progress.done();
        }
    }

    private void unzip(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        int fileCnt = this.getFileCount();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(fileCnt > 0 ? fileCnt : this.DEFAULT_FILE_COUNT));
        String archivePath = this.getArchivePath();
        BufferedInputStream bin = new BufferedInputStream(in);
        ZipInputStream zin = new ZipInputStream(bin);
        ZipEntry entry = zin.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            progress.subTask(NLS.bind((String)Messages.InstallableRuntime2_TaskUncompressing, (Object)name));
            if (archivePath != null && name.startsWith(archivePath) && (name = name.substring(archivePath.length())).length() > 1) {
                name = name.substring(1);
            }
            if (name != null && name.length() > 0) {
                if (entry.isDirectory()) {
                    path.append(name).toFile().mkdirs();
                } else {
                    FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                    this.copyWithSize(zin, fout, (IProgressMonitor)progress.newChild(1), (int)entry.getSize());
                    fout.close();
                    if (fileCnt <= 0) {
                        progress.setWorkRemaining(this.DEFAULT_FILE_COUNT);
                    }
                }
            }
            zin.closeEntry();
            entry = zin.getNextEntry();
        }
        zin.close();
    }

    protected void untar(InputStream in, IPath path, IProgressMonitor monitor) throws IOException {
        int fileCnt = this.getFileCount();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(fileCnt > 0 ? fileCnt : 500));
        String archivePath = this.getArchivePath();
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            TarInputStream zin = new TarInputStream((InputStream)bin);
            TarEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                progress.subTask(NLS.bind((String)Messages.InstallableRuntime2_TaskUncompressing, (Object)name));
                if (archivePath != null && name.startsWith(archivePath) && (name = name.substring(archivePath.length())).length() > 1) {
                    name = name.substring(1);
                }
                if (name != null && name.length() > 0) {
                    if (entry.getFileType() == 53) {
                        path.append(name).toFile().mkdirs();
                    } else {
                        File dir = path.append(name).removeLastSegments(1).toFile();
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        FileOutputStream fout = new FileOutputStream(path.append(name).toFile());
                        this.copyWithSize((InputStream)zin, fout, (IProgressMonitor)progress.newChild(1), (int)entry.getSize());
                        fout.close();
                        if (fileCnt <= 0) {
                            progress.setWorkRemaining(500);
                        }
                    }
                }
                entry = zin.getNextEntry();
            }
            zin.close();
        }
        catch (TarException ex) {
            throw new IOException(ex);
        }
    }

    protected void ungzip(InputStream in, File tarFile, IProgressMonitor monitor, int size) throws IOException {
        GZIPInputStream gzin = null;
        FileOutputStream fout = null;
        try {
            gzin = new GZIPInputStream(in);
            fout = new FileOutputStream(tarFile);
            this.copyWithSize(gzin, fout, monitor, size);
        }
        finally {
            if (gzin != null) {
                try {
                    gzin.close();
                }
                catch (IOException iOException) {}
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public String toString() {
        return "InstallableRuntime2[" + this.getId() + "]";
    }
}

