/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server.internal.lhttpd;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.pdtextensions.server.IPEXInstallableRuntime;
import org.pdtextensions.server.PEXServerPlugin;
import org.pdtextensions.server.internal.lhttpd.LinuxInstallable;
import org.pdtextensions.server.internal.lhttpd.Messages;
import org.pdtextensions.server.internal.lhttpd.Win32Installable;
import org.pdtextensions.server.lhttpd.ILHttpdLocationConfig;
import org.pdtextensions.server.lhttpd.ILHttpdPortConfig;
import org.pdtextensions.server.lhttpd.ILHttpdRuntime;
import org.pdtextensions.server.lhttpd.ILHttpdRuntimeWorkingCopy;

public class LHttpdServerRuntime
extends RuntimeDelegate
implements ILHttpdRuntime,
ILHttpdRuntimeWorkingCopy {
    private static final String[] HTTPD_EXECUTABLES = new String[]{"httpd.exe", "bin/httpd.exe", "apache2ctl", "bin/apache2ctl", "apache2", "bin/apache2", "httpd", "bin/httpd", "apache/bin/httpd.exe", "apache/bin/apache2ctl", "apache/bin/apache2", "apache/bin/httpd"};

    public void setDefaults(IProgressMonitor monitor) {
        IRuntimeType type = this.getRuntimeWorkingCopy().getRuntimeType();
        this.getRuntimeWorkingCopy().setLocation((IPath)new Path(PEXServerPlugin.getPreference("location" + type.getId())));
    }

    protected File getExecutable() {
        IPath location = this.getRuntime().getLocation();
        File locationPath = location.toFile();
        String[] stringArray = HTTPD_EXECUTABLES;
        int n = HTTPD_EXECUTABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String ex = stringArray[n2];
            File exe = new File(locationPath, ex);
            if (exe.isFile() && exe.exists()) {
                return exe;
            }
            ++n2;
        }
        return null;
    }

    protected IStatus verifyLocation() {
        if (this.getExecutable() == null) {
            return new Status(4, "org.pdtextensions.server", Messages.LHttpdServerRuntime_HttpdExecutableNotFound);
        }
        return Status.OK_STATUS;
    }

    public IStatus validate() {
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = this.verifyLocation();
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    public IPEXInstallableRuntime getInstallableRuntime() {
        if ("win32".equals(Platform.getOS())) {
            return new Win32Installable();
        }
        if ("linux".equals(Platform.getOS())) {
            return new LinuxInstallable();
        }
        return null;
    }

    @Override
    public ILHttpdPortConfig[] getPortConfigurations() {
        return null;
    }

    @Override
    public String getHttpdConf() {
        return null;
    }

    @Override
    public String getHttpdConf(int flags) {
        return null;
    }

    @Override
    public String getDefaultHtdocs() {
        return null;
    }

    @Override
    public ILHttpdLocationConfig[] getLocationConfigs() {
        return null;
    }

    @Override
    public String getAllowOverride() {
        return null;
    }
}

