/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server.internal.web;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.pdtextensions.server.internal.web.IWebProjectStorage;
import org.pdtextensions.server.web.IPhpWebFolder;

public class SettingsPhpProjectStorage
implements IWebProjectStorage {
    private static final String PREFS_DEFAULT_WEB_ROOT = "defaultWebRoot";
    private static final String PREFS_FOLDER_COUNT = "folderCount";
    private static final String PREFS_FOLDER_CONTAINER = "folder.container.";
    private static final String PREFS_FOLDER_PATHNAME = "folder.pathName.";
    private static final String PREFS_QUALIFIER = "org.pdtextensions.server.webproject";
    public static final String SETTINGS_FILENAME = ".settings/org.pdtextensions.server.webproject.prefs";
    private IProject project;
    private IContainer defaultWebFolder;
    private List<WebFolder> folders = new ArrayList<WebFolder>();
    private boolean prefsChanging = false;

    public SettingsPhpProjectStorage(IProject project) throws BackingStoreException {
        this.project = project;
        this.reload();
    }

    public void reload() throws BackingStoreException {
        if (!this.prefsChanging) {
            String def;
            this.folders.clear();
            ProjectScope scope = new ProjectScope(this.project);
            IEclipsePreferences prefs = scope.getNode(PREFS_QUALIFIER);
            this.defaultWebFolder = prefs.nodeExists(PREFS_DEFAULT_WEB_ROOT) ? ((def = prefs.get(PREFS_DEFAULT_WEB_ROOT, null)).length() == 0 ? this.project : this.project.getFolder(def)) : this.project;
            if (prefs.nodeExists(PREFS_FOLDER_COUNT)) {
                int i = 0;
                while (i < prefs.getInt(PREFS_FOLDER_COUNT, 0)) {
                    String container = prefs.get(PREFS_FOLDER_CONTAINER + i, null);
                    String pathName = prefs.get(PREFS_FOLDER_PATHNAME + i, null);
                    this.folders.add(new WebFolder((IContainer)this.project.getFolder(container), pathName));
                    ++i;
                }
            }
        }
    }

    @Override
    public IContainer getDefaultWebFolder() {
        return this.defaultWebFolder;
    }

    @Override
    public void setDefaultWebFolder(IContainer folder) throws CoreException {
        if (!folder.getProject().equals((Object)this.project)) {
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Container not within target project"));
        }
        this.prefsChanging = true;
        try {
            ProjectScope scope = new ProjectScope(this.project);
            IEclipsePreferences prefs = scope.getNode(PREFS_QUALIFIER);
            prefs.put(PREFS_DEFAULT_WEB_ROOT, folder.getProjectRelativePath().toString());
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Error while saving preferences", (Throwable)e));
            }
            this.defaultWebFolder = folder;
        }
        finally {
            this.prefsChanging = false;
        }
    }

    @Override
    public IPhpWebFolder[] getWebFolders() {
        return this.folders.toArray(new IPhpWebFolder[this.folders.size()]);
    }

    @Override
    public IPhpWebFolder createWebFolder(IContainer folder, String pathName) throws CoreException {
        if (!folder.getProject().equals((Object)this.project)) {
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Container not within target project"));
        }
        if (!pathName.startsWith("/")) {
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Path name must start with /"));
        }
        for (WebFolder f : this.folders) {
            if (f.getFolder().equals((Object)folder)) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Duplicate container"));
            }
            if (!f.getPathName().equals(pathName)) continue;
            throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Duplicate path namne"));
        }
        WebFolder result = new WebFolder(folder, pathName);
        this.folders.add(result);
        this.saveFolders();
        return result;
    }

    private void saveFolders() throws CoreException {
        this.prefsChanging = true;
        try {
            ProjectScope scope = new ProjectScope(this.project);
            IEclipsePreferences prefs = scope.getNode(PREFS_QUALIFIER);
            prefs.put(PREFS_FOLDER_COUNT, String.valueOf(this.folders.size()));
            int i = 0;
            while (i < this.folders.size()) {
                WebFolder folder = this.folders.get(i);
                prefs.put(PREFS_FOLDER_CONTAINER + i, folder.getFolder().getProjectRelativePath().toString());
                prefs.put(PREFS_FOLDER_PATHNAME + i, folder.getPathName());
                ++i;
            }
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Error while saving preferences", (Throwable)e));
            }
        }
        finally {
            this.prefsChanging = false;
        }
    }

    @Override
    public void removeWebFolder(IPhpWebFolder folder) throws CoreException {
        if (this.folders.remove(folder)) {
            this.saveFolders();
        }
    }

    private final class WebFolder
    implements IPhpWebFolder {
        private IContainer folder;
        private String pathName;

        public WebFolder(IContainer folder, String pathName) {
            this.folder = folder;
            this.pathName = pathName;
        }

        @Override
        public IContainer getFolder() {
            return this.folder;
        }

        @Override
        public String getPathName() {
            return this.pathName;
        }

        @Override
        public void set(IContainer folder, String pathName) throws CoreException {
            if (!folder.getProject().equals((Object)SettingsPhpProjectStorage.this.project)) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Container not within target project"));
            }
            if (!pathName.startsWith("/")) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Path name must start with /"));
            }
            for (WebFolder f : SettingsPhpProjectStorage.this.folders) {
                if (f.getFolder().equals((Object)folder) && f != this) {
                    throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Duplicate container"));
                }
                if (!f.getPathName().equals(pathName) || f == this) continue;
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Duplicate path namne"));
            }
            this.folder = folder;
            this.pathName = pathName;
            SettingsPhpProjectStorage.this.saveFolders();
        }
    }
}

