/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.editor;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import si.gos.eclipse.actions.PartAction;
import si.gos.eclipse.editor.SharedFormPage;
import si.gos.eclipse.editor.SharedSection;
import si.gos.eclipse.forms.FormLayoutFactory;
import si.gos.eclipse.parts.StructuredViewerConfig;
import si.gos.eclipse.parts.StructuredViewerPart;
import si.gos.eclipse.widgets.utils.ToolkitFactory;

public abstract class StructuredViewerSection
extends SharedSection {
    protected StructuredViewerPart viewerPart;

    public StructuredViewerSection(SharedFormPage formPage, Composite parent, int style, StructuredViewerConfig config) {
        this(formPage, parent, style, true, config);
    }

    public StructuredViewerSection(SharedFormPage formPage, Composite parent, int style, boolean titleBar, StructuredViewerConfig config) {
        super(formPage, parent, style, titleBar);
        this.viewerPart = this.createViewerPart(config);
        this.viewerPart.setMinimumSize(50, 50);
        FormToolkit toolkit = formPage.getManagedForm().getToolkit();
        this.createClient(this.getSection(), toolkit);
    }

    protected abstract StructuredViewerPart createViewerPart(StructuredViewerConfig var1);

    public StructuredViewerPart getStructuredViewerPart() {
        return this.viewerPart;
    }

    protected void createViewerPartControl(Composite parent, FormToolkit toolkit) {
        this.viewerPart.createControl(parent, new ToolkitFactory(toolkit));
    }

    protected Composite createClientContainer(Composite parent, int span, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, span));
        return container;
    }

    public PartAction[] getActions() {
        return this.viewerPart.getActions();
    }

    public PartAction getAction(int index) {
        return this.viewerPart.getAction(index);
    }

    protected void registerContextMenu(IMenuManager contextMenuManager) {
    }

    protected void fillContextMenu(IMenuManager manager) {
    }

    protected void handleAction(int index) {
    }

    protected void selectionChanged(IStructuredSelection selection) {
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewerPart.getViewer().getSelection();
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        return false;
    }

    public void setFocus() {
        this.viewerPart.getControl().setFocus();
    }

    @Override
    protected void updateEnabledState() {
        this.viewerPart.setEnabled(this.enabled);
    }

    protected boolean createCount() {
        return false;
    }

    protected boolean createContextMenu() {
        return true;
    }

    protected static interface IStructuredViewerAdapter {
        public void selectionChanged(IStructuredSelection var1);

        public void handleDoubleClick(IStructuredSelection var1);

        public void handleAction(PartAction var1, int var2);

        public void fillContextMenu(IMenuManager var1);

        public void registerContextMenu(IMenuManager var1);

        public boolean createCount();

        public boolean createContextMenu();
    }
}

