/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.exec;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.di.annotations.Creatable;
import si.gos.eclipse.exec.Environment;
import si.gos.eclipse.exec.EnvironmentFactory;
import si.gos.eclipse.exec.ExecutableNotFoundException;
import si.gos.eclipse.exec.ScriptLauncher;

@Creatable
public class ScriptLauncherManager {
    private static final String EXTENSION_POINT_ID = "si.gos.eclipse.exec";
    private final HashMap<String, EnvironmentFactory> factories = new HashMap();

    @Inject
    public ScriptLauncherManager(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(EXTENSION_POINT_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                EnvironmentFactory factory = (EnvironmentFactory)e.createExecutableExtension("class");
                if (factory != null) {
                    this.factories.put(e.getAttribute("id"), factory);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Environment getEnvironment(String factoryId, IProject project) throws ExecutableNotFoundException {
        if (!this.factories.containsKey(factoryId)) {
            return null;
        }
        return this.factories.get(factoryId).getEnvironment(project);
    }

    public ScriptLauncher getLauncher(String factoryId, IProject project) throws ExecutableNotFoundException {
        Environment env = this.getEnvironment(factoryId, project);
        if (env == null) {
            throw new ExecutableNotFoundException("Can't find any executable");
        }
        return new ScriptLauncher(env, project);
    }
}

