/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.parts;

import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import si.gos.eclipse.actions.PartAction;
import si.gos.eclipse.parts.ActionConfig;
import si.gos.eclipse.parts.SharedPart;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.eclipse.widgets.utils.WidgetHelper;

public abstract class ActionPart
extends SharedPart {
    public static final String ACTION_KEY = "action";
    protected String labelText = null;
    protected Label label;
    private PartAction[] actions;
    private boolean[] enabledStates;
    private Button[] buttons;
    protected Composite buttonContainer;
    private Shell shell;

    public ActionPart(ActionConfig config) {
        this.createActions(config.getActionLabels());
        this.labelText = config.getLabel();
    }

    public ActionPart(String[] actionLabels) {
        this.createActions(actionLabels);
    }

    private void createActions(String[] actionLabels) {
        this.actions = new PartAction[actionLabels.length];
        int i = 0;
        while (i < actionLabels.length) {
            int index = i;
            String label = actionLabels[i];
            this.actions[i] = this.createAction(label, index);
            ++i;
        }
    }

    protected PartAction createAction(String label, final int index) {
        return new PartAction(label){

            public void run() {
                ActionPart.this.handleAction(this, index);
            }
        };
    }

    public PartAction getAction(int index) {
        if (this.actions == null || index < 0 || index >= this.actions.length) {
            return null;
        }
        return this.actions[index];
    }

    public PartAction[] getActions() {
        return this.actions;
    }

    public void setActionEnabled(int index, boolean enabled) {
        if (this.actions != null && index >= 0 && this.actions.length > index) {
            this.actions[index].setEnabled(enabled);
        }
    }

    public void setActionVisible(int index, boolean visible) {
        if (this.actions != null && index >= 0 && this.actions.length > index) {
            this.actions[index].setVisible(visible);
        }
    }

    @Override
    protected Shell getShell() {
        return this.shell;
    }

    protected abstract void handleAction(PartAction var1, int var2);

    @Override
    public Composite createControl(Composite parent, IWidgetFactory factory) {
        this.shell = parent.getShell();
        Composite container = this.createContainer(parent, factory);
        this.createMainLabel(container, factory);
        this.createMainControl(container, factory);
        this.createButtons(container, factory);
        return container;
    }

    public Composite createContainer(Composite parent, IWidgetFactory factory) {
        Composite container = factory.createComposite(parent, 16);
        container.setLayout((Layout)new GridLayout(2, false));
        WidgetHelper.fillBoth(container);
        WidgetHelper.setMargin(container, 0, 0);
        WidgetHelper.setSpacing(container, 0, 0);
        return container;
    }

    protected abstract void createMainControl(Composite var1, IWidgetFactory var2);

    protected void createButtons(Composite parent, IWidgetFactory factory) {
        if (this.actions != null && this.actions.length > 0) {
            this.buttonContainer = factory.createComposite(parent);
            GridData gd = new GridData(1040);
            this.buttonContainer.setLayoutData((Object)gd);
            this.buttonContainer.setLayout((Layout)this.createButtonsLayout());
            this.buttons = new Button[this.actions.length];
            SelectionHandler listener = new SelectionHandler();
            int i = 0;
            while (i < this.actions.length) {
                String label = this.actions[i].getText();
                if (label != null) {
                    Button button = this.createButton(this.buttonContainer, label, i, factory);
                    button.addSelectionListener((SelectionListener)listener);
                    this.buttons[i] = button;
                } else {
                    this.createEmptySpace(this.buttonContainer, 1, factory);
                }
                ++i;
            }
        }
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        return layout;
    }

    protected Button createButton(Composite parent, String label, int index, IWidgetFactory factory) {
        boolean visible = this.getAction(index).isVisible();
        final Button button = factory.createButton(parent, label, 8);
        GridData gd = new GridData(770);
        gd.exclude = !visible;
        button.setLayoutData((Object)gd);
        button.setData((Object)new Integer(index));
        button.setVisible(visible);
        PartAction action = this.getAction(index);
        action.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String prop = event.getProperty();
                if (prop.equals("enabled")) {
                    button.setEnabled(((Boolean)event.getNewValue()).booleanValue());
                } else if (prop.equals("visible")) {
                    GridData gd = (GridData)button.getLayoutData();
                    gd.exclude = (Boolean)event.getNewValue() == false;
                    button.setLayoutData((Object)gd);
                    button.setVisible(((Boolean)event.getNewValue()).booleanValue());
                    button.getParent().layout(true, true);
                } else if (prop.equals("text")) {
                    button.setText((String)event.getNewValue());
                }
            }
        });
        button.setData(ACTION_KEY, (Object)action);
        button.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)button);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return button;
    }

    @Override
    protected void updateEnabledState() {
        if (this.enabledStates == null) {
            this.enabledStates = new boolean[this.actions.length];
        }
        int i = 0;
        while (i < this.actions.length) {
            if (this.isEnabled()) {
                this.actions[i].setEnabled(this.enabledStates[i]);
            } else {
                this.enabledStates[i] = this.actions[i] != null ? this.actions[i].isEnabled() : true;
            }
            ++i;
        }
    }

    @Override
    protected void updateGrayedState() {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setGrayed(this.isGrayed());
            ++i;
        }
        super.updateGrayedState();
    }

    protected void createMainLabel(Composite parent, IWidgetFactory factory) {
        if (this.labelText != null) {
            this.label = factory.createLabel(parent, this.labelText);
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            this.label.setLayoutData((Object)gd);
        }
    }

    public Button getButton(int index) {
        if (this.buttons == null || index < 0 || index >= this.buttons.length) {
            return null;
        }
        return this.buttons[index];
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        private void buttonSelected(SelectionEvent e) {
            Object action = e.widget.getData(ActionPart.ACTION_KEY);
            if (action instanceof PartAction) {
                ((PartAction)((Object)action)).run();
            }
        }
    }
}

