/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.parts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import si.gos.eclipse.actions.PartAction;
import si.gos.eclipse.parts.ActionPart;
import si.gos.eclipse.parts.StructuredViewerConfig;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.eclipse.widgets.utils.ToolkitFactory;

public abstract class StructuredViewerPart
extends ActionPart {
    public static final boolean DEFAULT_CREATE_COUNT = false;
    public static final boolean DEFAULT_CREATE_CONTEXT_MENU = true;
    private StructuredViewer viewer;
    private Point minSize;
    private List<Integer> sensitiveActions = new ArrayList<Integer>();
    protected Label count;
    private MenuManager contextMenuManager;
    private List<ISelectionChangedListener> selectionChangedListener = new ArrayList<ISelectionChangedListener>();

    public StructuredViewerPart(String[] actionLabels) {
        super(actionLabels);
    }

    public StructuredViewerPart(String[] actionLabels, int[] sensitiveActions) {
        super(actionLabels);
        this.initSensitiveActions(sensitiveActions);
    }

    public StructuredViewerPart(StructuredViewerConfig config) {
        super(config);
        this.initSensitiveActions(config.getSensitiveActions());
    }

    private void initSensitiveActions(int[] sensitiveActions) {
        int i = 0;
        while (i < sensitiveActions.length) {
            this.sensitiveActions.add(sensitiveActions[i]);
            ++i;
        }
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangedListener.contains(listener)) {
            this.selectionChangedListener.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListener.remove(listener);
    }

    @Override
    protected void createMainControl(Composite parent, IWidgetFactory factory) {
        this.viewer = this.createStructuredViewer(parent, factory);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                StructuredViewerPart.this.selectionChanged((IStructuredSelection)e.getSelection());
                Iterator iterator = StructuredViewerPart.this.sensitiveActions.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    StructuredViewerPart.this.getButton(index).setEnabled(!e.getSelection().isEmpty() && StructuredViewerPart.this.isEnabled());
                }
                for (ISelectionChangedListener listener : StructuredViewerPart.this.selectionChangedListener) {
                    listener.selectionChanged(e);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredViewerPart.this.handleDoubleClick((IStructuredSelection)e.getSelection());
            }
        });
        Control control = this.viewer.getControl();
        control.setLayoutData((Object)new GridData(1808));
        this.applyMinimumSize();
        if (this.createContextMenu()) {
            this.contextMenuManager = new MenuManager();
            IMenuListener listener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager mng) {
                    StructuredViewerPart.this.fillContextMenu(mng);
                }
            };
            this.contextMenuManager.addMenuListener(listener);
            this.contextMenuManager.setRemoveAllWhenShown(true);
            Menu menu = this.contextMenuManager.createContextMenu(control);
            control.setMenu(menu);
            this.registerContextMenu((IMenuManager)this.contextMenuManager);
        }
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, IWidgetFactory var2);

    @Override
    protected void createButtons(Composite parent, IWidgetFactory factory) {
        super.createButtons(parent, factory);
        if (this.createCount()) {
            Composite comp = factory.createComposite(this.buttonContainer);
            comp.setLayout((Layout)this.createButtonsLayout());
            comp.setLayoutData((Object)new GridData(1816));
            this.count = factory.createLabel(comp);
            this.count.setLayoutData((Object)new GridData(768));
            if (factory instanceof ToolkitFactory) {
                this.count.setForeground(((ToolkitFactory)factory).getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
            }
            this.getControl().addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    StructuredViewerPart.this.updateLabel();
                }
            });
        }
    }

    @Override
    protected Button createButton(Composite parent, String label, int index, IWidgetFactory factory) {
        Button button = super.createButton(parent, label, index, factory);
        if (this.sensitiveActions.contains(index)) {
            button.setEnabled(false);
        }
        return button;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        for (int index : this.sensitiveActions) {
            this.getAction(index).setEnabled(!selection.isEmpty());
        }
    }

    protected abstract void updateLabel();

    protected boolean createCount() {
        return false;
    }

    protected boolean createContextMenu() {
        return true;
    }

    public void setMinimumSize(int width, int height) {
        this.minSize = new Point(width, height);
        if (this.viewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.minSize != null) {
            GridData gd = (GridData)this.viewer.getControl().getLayoutData();
            gd.widthHint = this.minSize.x;
            gd.heightHint = this.minSize.y;
        }
    }

    protected void registerContextMenu(IMenuManager contextMenuManager) {
    }

    protected void fillContextMenu(IMenuManager manager) {
        PartAction[] partActionArray = this.getActions();
        int n = partActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            PartAction action = partActionArray[n2];
            if (action.isVisible()) {
                manager.add((IAction)action);
            }
            ++n2;
        }
    }

    protected IMenuManager getContextMenu() {
        return this.contextMenuManager;
    }

    @Override
    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }

    @Override
    protected void handleAction(PartAction action, int index) {
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
    }
}

