/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.core.builder;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import si.gos.eclipse.exec.ExecutionResponseAdapter;

public class ConsoleResponseHandler
extends ExecutionResponseAdapter {
    private MessageConsole console = this.findConsole("Transpiler");

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole console = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{console});
        return console;
    }

    public void executionAboutToStart() {
        this.console.clearConsole();
    }

    public void executionMessage(String message) {
        this.logMessage(message);
    }

    public void executionFailed(String response, Exception e) {
        this.logError("Transpiling failed: " + e.getMessage());
    }

    public void executionError(String message) {
        this.logError("Error while transpiling: " + message);
    }

    private void logError(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageConsoleStream out = ConsoleResponseHandler.this.console.newMessageStream();
                out.setColor(new Color((Device)Display.getDefault(), 255, 0, 0));
                out.println(message);
            }
        });
    }

    private void logMessage(String message) {
        MessageConsoleStream out = this.console.newMessageStream();
        out.println(message);
    }
}

