/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import si.gos.transpiler.core.TranspilerPlugin;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.core.model.PathEntry;
import si.gos.transpiler.core.model.TranspileItem;
import si.gos.transpiler.core.transpiler.ITranspiler;
import si.gos.transpiler.core.transpiler.ITranspilerManager;
import si.gos.transpiler.core.transpiler.InstalledTranspiler;

public class ResourceLocator {
    private IProject project;
    private ITranspilerManager manager;
    private List<PathEntry> paths;

    public ResourceLocator(IProject project) {
        this.project = project;
        this.manager = TranspilerPlugin.getDefault().getTranspilerManager();
        this.fetchSources();
    }

    public void fetchSources() {
        this.paths = new ArrayList<PathEntry>();
        ArrayList<ConfiguredTranspiler> cts = new ArrayList<ConfiguredTranspiler>(this.manager.getConfiguredTranspilers(this.project).values());
        for (ConfiguredTranspiler ct : cts) {
            for (PathEntry path : ct.getPaths()) {
                this.paths.add(path);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (PathEntry path : this.paths) {
            sb.append(path.getSource().getProjectRelativePath() + ", ");
        }
    }

    public TranspileItem getTranspileItem(IPath path) {
        for (PathEntry pathEntry : this.paths) {
            IResource sourceResource = pathEntry.getSource();
            if (sourceResource == null || !sourceResource.exists()) continue;
            IPath sourcePath = sourceResource.getProjectRelativePath();
            InstalledTranspiler itp = pathEntry.getConfiguredTranspiler().getInstalledTranspiler();
            ITranspiler transpiler = itp.getTranspiler();
            if (sourceResource instanceof IFile && sourcePath.equals((Object)path)) {
                IPath dest = transpiler.getOutputOption(path, pathEntry.getDestination().getProjectRelativePath());
                return new TranspileItem(pathEntry, path, dest);
            }
            if (!(sourceResource instanceof IFolder)) continue;
            sourcePath = sourcePath.addTrailingSeparator();
            IPath folder = path.removeLastSegments(1).addTrailingSeparator();
            String sourceExt = itp.getSourceExtension();
            if (!sourcePath.equals((Object)folder) || !path.getFileExtension().equals(sourceExt)) continue;
            String filename = path.lastSegment();
            filename = filename.replaceFirst("(.*)" + sourceExt + "$", "$1" + itp.getDestinationExtension());
            IPath destFolder = pathEntry.getDestination().getProjectRelativePath();
            IPath dest = transpiler.getOutputOption(path, destFolder.append(filename));
            return new TranspileItem(pathEntry, path, dest);
        }
        return null;
    }

    public IProject getProject() {
        return this.project;
    }
}

