/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.core.transpiler;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import si.gos.eclipse.exec.ExecutionResponseAdapter;
import si.gos.eclipse.exec.ExecutionResponseListener;
import si.gos.eclipse.exec.Launcher;
import si.gos.transpiler.core.transpiler.ITranspiler;
import si.gos.transpiler.core.transpiler.Option;

public abstract class AbstractTranspiler
implements ITranspiler {
    protected String name;
    protected String id;
    protected String cmd;
    protected String sourceExtension;
    protected String destinationExtension;
    private String lastExecMessage;
    protected Map<String, Option> options;

    public void init(IConfigurationElement config) {
        IConfigurationElement[] optionNodes;
        this.name = config.getAttribute("name") != null ? config.getAttribute("name") : "";
        this.id = config.getAttribute("id") != null ? config.getAttribute("id") : "";
        this.sourceExtension = config.getAttribute("sourceExtension") != null ? config.getAttribute("sourceExtension") : "";
        this.destinationExtension = config.getAttribute("destinationExtension") != null ? config.getAttribute("destinationExtension") : "";
        this.cmd = config.getAttribute("cmd") != null ? config.getAttribute("cmd") : "";
        this.options = new LinkedHashMap<String, Option>();
        IConfigurationElement[] iConfigurationElementArray = optionNodes = config.getChildren("option");
        int n = optionNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement o = iConfigurationElementArray[n2];
            this.options.put(o.getAttribute("name"), new Option(o));
            ++n2;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSourceExtension() {
        return this.sourceExtension;
    }

    @Override
    public String getDestinationExtension() {
        return this.destinationExtension;
    }

    @Override
    public String getCmd() {
        return this.cmd;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public Map<String, Option> getOptions() {
        return this.options;
    }

    @Override
    public Option getOption(String name) {
        return this.options.get(name);
    }

    protected String buildOptionArgs(Map<String, String> options) {
        StringBuilder ob = new StringBuilder();
        if (options != null && options.size() > 0) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                Option option = this.getOption(entry.getKey());
                ob.append("--" + entry.getKey());
                if (!option.isBoolean()) {
                    ob.append("=" + entry.getValue());
                }
                ob.append(" ");
            }
        }
        return ob.toString().trim();
    }

    @Override
    public IPath getOutputOption(IPath from, IPath to) {
        return to;
    }

    @Override
    public CommandLine getCommand(String path, Map<String, String> options) {
        String cmd = this.cmd;
        cmd = cmd.replace("$path", path);
        cmd = cmd.replace("$source", "\"${source}\"");
        cmd = cmd.replace("$destination", "\"${destination}\"");
        cmd = cmd.replace("$options", this.buildOptionArgs(options));
        return CommandLine.parse((String)cmd);
    }

    protected String checkLocations(String bin) {
        String[] paths;
        String[] stringArray = paths = new String[]{"/usr/local/bin"};
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String binPath = String.valueOf((path = String.valueOf(path) + "/").replace("//", "/")) + bin;
            File f = new File(binPath);
            if (f.exists()) {
                return binPath;
            }
            ++n2;
        }
        return "";
    }

    protected String exec(String command) {
        this.lastExecMessage = "";
        Launcher launcher = new Launcher();
        launcher.addResponseListener((ExecutionResponseListener)new ExecutionResponseAdapter(){

            public void executionMessage(String message) {
                AbstractTranspiler.this.lastExecMessage = message;
            }
        });
        try {
            launcher.launch(CommandLine.parse((String)command));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.lastExecMessage;
    }
}

