/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.internal.core.transpiler;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;
import si.gos.transpiler.core.TranspilerPlugin;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.core.model.PathEntry;
import si.gos.transpiler.core.transpiler.AbstractTranspiler;
import si.gos.transpiler.core.transpiler.ITranspiler;
import si.gos.transpiler.core.transpiler.ITranspilerManager;
import si.gos.transpiler.core.transpiler.InstalledTranspiler;

public class TranspilerManager
implements ITranspilerManager {
    public static final String TRANSPILER_EXTENSION_POINT = "si.gos.transpiler.core.transpiler";
    private static final String TRANSPILER = "transpiler";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String CMD = "cmd";
    private static final String SOURCE_EXTENSION = "source-extension";
    private static final String DESTINATION_EXTENSION = "destination-extension";
    private static final String OPTIONS = "options";
    private static final String PATHS = "paths";
    private static final String PATH_SEPARATOR = ":";
    private static final String RESOURCE_SEPARATOR = "::";
    private IEclipsePreferences prefs = TranspilerPlugin.getDefault().getPreferences();
    private IPreferenceStore store = TranspilerPlugin.getDefault().getPreferenceStore();
    private Map<String, ITranspiler> transpilers = this.loadTranspilers();
    private Map<String, InstalledTranspiler> installedTranspilers = this.loadInstalledTranspilers();
    private Map<IProject, Map<String, ConfiguredTranspiler>> configuredTranspilers = new LinkedHashMap<IProject, Map<String, ConfiguredTranspiler>>();

    @Override
    public Map<String, ITranspiler> getTranspilers() {
        return this.transpilers;
    }

    private Map<String, ITranspiler> loadTranspilers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(TRANSPILER_EXTENSION_POINT);
        LinkedHashMap<String, ITranspiler> transpilers = new LinkedHashMap<String, ITranspiler>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object transpiler = element.createExecutableExtension("class");
                if (transpiler instanceof AbstractTranspiler) {
                    ((AbstractTranspiler)transpiler).init(element);
                    transpilers.put(element.getAttribute("id"), (ITranspiler)transpiler);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return transpilers;
    }

    @Override
    public ITranspiler getTranspiler(String id) {
        if (this.transpilers.containsKey(id)) {
            return this.transpilers.get(id);
        }
        return null;
    }

    @Override
    public boolean isTranspilerInstalled(String id) {
        this.getInstalledTranspilers();
        for (InstalledTranspiler transpiler : this.installedTranspilers.values()) {
            if (!transpiler.getTranspiler().getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, InstalledTranspiler> getInstalledTranspilers() {
        return this.installedTranspilers;
    }

    @Override
    public InstalledTranspiler getInstalledTranspiler(String id) {
        if (this.installedTranspilers.containsKey(id)) {
            return this.installedTranspilers.get(id);
        }
        return null;
    }

    @Override
    public void addInstalledTranspiler(InstalledTranspiler transpiler) {
        this.installedTranspilers.put(transpiler.getId(), transpiler);
    }

    @Override
    public void removeInstalledTranspiler(InstalledTranspiler transpiler) {
        this.installedTranspilers.remove(transpiler.getId());
    }

    private Map<String, InstalledTranspiler> loadInstalledTranspilers() {
        LinkedHashMap<String, InstalledTranspiler> transpilers = new LinkedHashMap<String, InstalledTranspiler>();
        String[] stringArray = this.getInstalledTranspilerIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            InstalledTranspiler itp = this.loadInstalledTranspiler(id);
            if (itp != null) {
                transpilers.put(id, itp);
            }
            ++n2;
        }
        return transpilers;
    }

    private InstalledTranspiler loadInstalledTranspiler(String id) {
        String root = "transpilers/" + id;
        try {
            if (this.prefs.nodeExists(root)) {
                IEclipsePreferences node = (IEclipsePreferences)this.prefs.node(root);
                String transpilerId = node.get(TRANSPILER, "");
                InstalledTranspiler transpiler = new InstalledTranspiler();
                transpiler.setId(id);
                transpiler.setName(node.get(NAME, ""));
                transpiler.setPath(node.get(PATH, ""));
                transpiler.setCmd(node.get(CMD, ""));
                transpiler.setSourceExtension(node.get(SOURCE_EXTENSION, ""));
                transpiler.setDestinationExtension(node.get(DESTINATION_EXTENSION, ""));
                transpiler.setTranspilerId(transpilerId);
                transpiler.setTranspiler(this.getTranspiler(transpilerId));
                return transpiler;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String[] getInstalledTranspilerIds() {
        String list = this.store.getString("transpilers");
        if (list.equals("")) {
            return new String[0];
        }
        return list.split(",");
    }

    @Override
    public void saveInstalledTranspilers() {
        try {
            String[] stringArray = this.getInstalledTranspilerIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                String root = "transpilers/" + id;
                this.prefs.node(root).removeNode();
                ++n2;
            }
            for (InstalledTranspiler transpiler : this.installedTranspilers.values()) {
                String root = "transpilers/" + transpiler.getId();
                IEclipsePreferences node = (IEclipsePreferences)this.prefs.node(root);
                node.put(TRANSPILER, transpiler.getTranspilerId());
                node.put(CMD, transpiler.getCmd());
                node.put(PATH, transpiler.getPath());
                node.put(NAME, transpiler.getName());
                node.put(SOURCE_EXTENSION, transpiler.getSourceExtension());
                node.put(DESTINATION_EXTENSION, transpiler.getDestinationExtension());
                node.flush();
            }
            String list = StringUtils.join((Object[])this.installedTranspilers.keySet().toArray(new String[0]), (char)',');
            this.store.putValue("transpilers", list);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, ConfiguredTranspiler> getConfiguredTranspilers(IProject project) {
        if (this.configuredTranspilers.containsKey(project)) {
            return this.configuredTranspilers.get(project);
        }
        IEclipsePreferences prefs = TranspilerPlugin.getDefault().getProjectPreferences(project);
        String list = prefs.get("transpilers", "");
        String[] ids = new String[]{};
        if (!list.equals("")) {
            ids = list.split(",");
        }
        LinkedHashMap<String, ConfiguredTranspiler> ctps = new LinkedHashMap<String, ConfiguredTranspiler>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String optionsString;
            int n3;
            String id = stringArray[n2];
            ConfiguredTranspiler ctp = new ConfiguredTranspiler();
            ctp.setInstalledTranspiler(this.getInstalledTranspiler(id));
            String root = "transpilers/" + id;
            IEclipsePreferences tp = (IEclipsePreferences)prefs.node(root);
            String paths = tp.get(PATHS, "");
            if (paths.length() > 0) {
                String[] resources;
                String[] stringArray2 = resources = paths.split(RESOURCE_SEPARATOR);
                n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    String resource = stringArray2[n4];
                    String[] parts = resource.split(PATH_SEPARATOR);
                    ctp.addPath(new PathEntry(project.findMember(parts[0]), project.findMember(parts[1])));
                    ++n4;
                }
            }
            if ((optionsString = tp.get(OPTIONS, "")).length() > 0) {
                String[] options;
                String[] stringArray3 = options = optionsString.split(RESOURCE_SEPARATOR);
                int n5 = options.length;
                n3 = 0;
                while (n3 < n5) {
                    String option = stringArray3[n3];
                    String[] parts = option.split("=");
                    ctp.setOption(parts[0]);
                    if (parts.length > 1) {
                        ctp.setOption(parts[0], parts[1]);
                    }
                    ++n3;
                }
            }
            ctps.put(ctp.getId(), ctp);
            ++n2;
        }
        this.configuredTranspilers.put(project, ctps);
        return ctps;
    }

    @Override
    public void saveConfiguredTranspilers(IProject project, Map<String, ConfiguredTranspiler> configuredTranspilers) {
        IEclipsePreferences prefs = TranspilerPlugin.getDefault().getProjectPreferences(project);
        prefs.put("transpilers", StringUtils.join((Object[])configuredTranspilers.keySet().toArray(new String[0]), (char)','));
        try {
            for (ConfiguredTranspiler ctp : configuredTranspilers.values()) {
                String root = "transpilers/" + ctp.getId();
                IEclipsePreferences tp = (IEclipsePreferences)prefs.node(root);
                LinkedList<String> resources = new LinkedList<String>();
                for (PathEntry path : ctp.getPaths()) {
                    resources.add(path.getSource().getProjectRelativePath() + PATH_SEPARATOR + path.getDestination().getProjectRelativePath());
                }
                tp.put(PATHS, StringUtils.join(resources, (String)RESOURCE_SEPARATOR));
                LinkedList<String> options = new LinkedList<String>();
                for (Map.Entry<String, String> option : ctp.getOptions().entrySet()) {
                    StringBuilder sb = new StringBuilder(option.getKey());
                    if (!option.getValue().isEmpty()) {
                        sb.append("=" + option.getValue());
                    }
                    options.add(sb.toString());
                }
                tp.put(OPTIONS, StringUtils.join(options, (String)RESOURCE_SEPARATOR));
            }
            this.configuredTranspilers.put(project, configuredTranspilers);
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

