/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.ui.corext.template.php.CodeTemplateContextType;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.themes.ColorUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.osgi.framework.BundleContext;
import org.pdtextensions.core.log.Logger;
import org.pdtextensions.core.ui.preferences.PDTTemplateStore;

public class PEXUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.pdtextensions.core.ui";
    public static final String MARKER_ID = "org.pdtextensions.core.ui.problem";
    private IPreferenceStore fCombinedPreferenceStore;
    private PDTTemplateStore fCodeTemplateStore;
    protected ContextTypeRegistry codeTypeRegistry = null;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private static PEXUIPlugin plugin;
    private Color color;
    private IEclipseContext eclipseContext;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public static PEXUIPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        PEXUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PEXUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage(), e));
    }

    public static void log(int severity, String message) {
        PEXUIPlugin.log((IStatus)new Status(severity, PLUGIN_ID, message));
    }

    public static void warning(String string, ASTNode node, int offset, int end) {
        PEXUIPlugin.log((IStatus)new Status(2, PLUGIN_ID, "Could not find '" + string + "' @" + node.getClass().getSimpleName() + " [" + offset + "-" + end + "]"));
    }

    public void createMarker(IResource resource, int severity, String message, boolean persist) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers(MARKER_ID, false, 2);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                Object msg;
                IMarker marker = iMarkerArray[n2];
                Object sev = marker.getAttribute("severity");
                if ((sev == null || sev.equals(severity)) && ((msg = marker.getAttribute("message")) == null || msg.equals(message))) {
                    return;
                }
                ++n2;
            }
        }
        catch (CoreException markers) {
            // empty catch block
        }
        try {
            IMarker marker = resource.createMarker(MARKER_ID);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", severity);
            map.put("message", message);
            if (!persist) {
                map.put("transient", true);
            }
            marker.setAttributes(map);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public Color getColor() {
        if (this.color == null) {
            String colorString = this.getPreferenceStore().getString("line_color");
            this.color = new Color((Device)PlatformUI.getWorkbench().getDisplay(), ColorUtil.getColorValue((String)colorString));
        }
        return this.color;
    }

    public void setColor(Color color) {
        if (this.color != null) {
            this.color.dispose();
        }
        this.color = color;
    }

    public IFile getFile(IDocument document) {
        IFile file = null;
        IStructuredModel structuredModel = null;
        try {
            String location;
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (structuredModel != null && (location = structuredModel.getBaseLocation()) != null) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(location));
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        return file;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            this.fCodeTemplateStore = new PDTTemplateStore(this.getCodeTemplateContextRegistry(), this.getPreferenceStore(), "org.pdtextensions.core.ui.formatter.text.custom_code_templates");
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                Logger.logException((Throwable)e);
            }
        }
        return this.fCodeTemplateStore;
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.codeTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            CodeTemplateContextType.registerContextTypes((ContextTypeRegistry)registry);
            this.codeTypeRegistry = registry;
        }
        return this.codeTypeRegistry;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return PEXUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public void showMissingExecutableDialog() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String title = "Missing PHP executable";
                String message = "There is no default PHP executable defined.";
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
            }
        });
    }

    public IEclipseContext getEclipseContext() {
        return this.eclipseContext;
    }
}

