/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui.codemanipulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.ui.CodeGeneration;
import org.pdtextensions.core.log.Logger;
import org.pdtextensions.core.ui.codemanipulation.ClassStubParameter;
import org.pdtextensions.core.ui.codemanipulation.ElementStub;
import org.pdtextensions.core.ui.codemanipulation.MethodStub;

public class ClassStub
extends ElementStub {
    protected boolean isAbstract;
    protected IType superclass;
    protected boolean generateConstructor;
    protected boolean generateInheritedMethods;
    protected boolean isFinal;
    private ArrayList<IMethod> unimplementedMethods;

    public ClassStub(IScriptProject scriptProject, ClassStubParameter parameters) {
        this.scriptProject = scriptProject;
        this.name = parameters.getName();
        this.superclass = parameters.getSuperclass();
        this.namespace = parameters.getNamespace();
        this.isFinal = parameters.isFinalClass();
        this.isAbstract = parameters.isAbstractClass();
        this.interfaces = parameters.getInterfaces();
        this.generateComments = parameters.isComments();
        this.generateConstructor = parameters.isConstructor();
        this.generateInheritedMethods = parameters.createInheritedMethods();
    }

    @Override
    protected void generateCode() {
        try {
            StringBuilder buffer = new StringBuilder("<?php");
            buffer.append(this.lineDelim);
            buffer.append(this.generateNamespacePart());
            if (this.generateComments) {
                buffer.append(String.valueOf(CodeGeneration.getTypeComment((IScriptProject)this.scriptProject, (String)this.name, (String)this.lineDelim)) + this.lineDelim);
            }
            if (this.isFinal) {
                buffer.append("final ");
            }
            if (this.isAbstract) {
                buffer.append("abstract ");
            }
            buffer.append("class " + this.name);
            buffer.append(this.generateAncestorsPart());
            buffer.append(this.generateInterfacesCode());
            buffer.append("{" + this.lineDelim);
            if (this.generateConstructor) {
                buffer.append(this.generateConstructor());
            }
            buffer.append(this.generateMethods());
            buffer.append(String.valueOf(this.lineDelim) + "}");
            this.code = buffer.toString();
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    private String generateConstructor() {
        String constructor = "";
        try {
            IMethod[] constructors = PHPModelUtils.getTypeMethod((IType)this.superclass, (String)"__construct", (boolean)true);
            if (constructors.length == 0) {
                constructors = PHPModelUtils.getSuperTypeHierarchyMethod((IType)this.superclass, (String)"__construct", (boolean)true, (IProgressMonitor)new NullProgressMonitor());
            }
            if (constructors.length != 0) {
                constructor = new MethodStub(this.scriptProject, constructors[0], this.generateComments).toString();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return constructor;
    }

    private String generateMethods() {
        String code = "";
        if (this.getUnimplementedMethods() != null) {
            for (IMethod method : this.unimplementedMethods) {
                code = String.valueOf(code) + new MethodStub(this.scriptProject, method, this.generateComments).toString();
            }
        }
        return code;
    }

    private boolean hasPossibleMethodsToImplement() {
        return this.superclass instanceof IType || this.interfaces != null && this.interfaces.size() > 0;
    }

    private ArrayList<IMethod> getUnimplementedMethods() {
        if (this.generateInheritedMethods && this.hasPossibleMethodsToImplement() && this.unimplementedMethods == null) {
            this.unimplementedMethods = new ArrayList();
            if (this.superclass != null) {
                Collections.addAll(this.unimplementedMethods, this.getUnimplementedMethods(this.superclass));
            }
            for (IType interfaceObject : this.interfaces) {
                System.err.println(interfaceObject);
                Collections.addAll(this.unimplementedMethods, this.getUnimplementedMethods(interfaceObject));
            }
        }
        return this.unimplementedMethods;
    }

    private IMethod[] getUnimplementedMethods(IType type) {
        try {
            return PHPModelUtils.getUnimplementedMethods((IType)type, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ModelException e) {
            Logger.logException((Throwable)e);
            return null;
        }
    }

    private String generateAncestorsPart() {
        if (this.superclass != null && this.superclass.getElementName() != null) {
            String prefix = this.getUseNamespaceString(this.superclass) == null ? "\\" : "";
            return " extends " + prefix + this.superclass.getElementName();
        }
        return "";
    }

    @Override
    protected HashSet<String> getUseNamespacesList() {
        HashSet<String> namespaces = super.getUseNamespacesList();
        if (this.superclass != null && this.getUseNamespaceString(this.superclass) != null) {
            namespaces.add(this.getUseNamespaceString(this.superclass));
        }
        return namespaces;
    }
}

