/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui.codemanipulation;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.ui.CodeGeneration;
import org.pdtextensions.core.log.Logger;
import org.pdtextensions.core.ui.codemanipulation.ElementStub;

public class InterfaceStub
extends ElementStub {
    public InterfaceStub(IScriptProject scriptProject, String name, String namespace, List<IType> ancestors, boolean generateComments) {
        this.scriptProject = scriptProject;
        this.interfaces = ancestors;
        this.generateComments = generateComments;
        this.name = name;
        this.namespace = namespace;
    }

    @Override
    protected void generateCode() {
        try {
            StringBuilder buffer = new StringBuilder("<?php");
            buffer.append(this.lineDelim);
            buffer.append(this.generateNamespacePart());
            if (this.generateComments) {
                buffer.append(String.valueOf(CodeGeneration.getTypeComment((IScriptProject)this.scriptProject, (String)this.name, (String)this.lineDelim)) + this.lineDelim);
            }
            buffer.append("interface " + this.name);
            buffer.append(this.generateAncestorsPart());
            buffer.append("{" + this.lineDelim);
            buffer.append(String.valueOf(this.lineDelim) + "}");
            this.code = buffer.toString();
        }
        catch (CoreException e) {
            Logger.logException((Throwable)e);
        }
    }

    private String generateAncestorsPart() {
        String code = new String();
        if (!this.interfaces.isEmpty()) {
            code = " extends";
            int size = this.interfaces.size();
            int i = 1;
            for (IType interfaceObject : this.interfaces) {
                String prefix = this.getUseNamespaceString(interfaceObject) == null ? "\\" : "";
                code = i < size ? String.valueOf(code) + " " + prefix + interfaceObject.getElementName() + "," : String.valueOf(code) + " " + prefix + interfaceObject.getElementName();
                ++i;
            }
        }
        return code;
    }
}

