/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui.codemanipulation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.ui.CodeGeneration;
import org.pdtextensions.core.util.PDTModelUtils;

public class MethodStub {
    private String lineDelimiter = "\n";
    private String code = "";
    private IScriptProject scriptProject = null;
    private IMethod method;
    private boolean generateComments;

    public MethodStub(IScriptProject scriptProject, IMethod method, boolean generateComments) {
        this.scriptProject = scriptProject;
        this.method = method;
        this.generateComments = generateComments;
    }

    private void generateCode() throws CoreException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.lineDelimiter);
        buffer.append(this.generateComments());
        buffer.append(this.lineDelimiter);
        buffer.append(this.generateAccess());
        buffer.append(" function " + this.method.getElementName());
        buffer.append("(" + this.generateParamsWithTypes() + ")");
        buffer.append(this.generateBody());
        this.code = buffer.toString();
    }

    private String generateParamsWithoutTypes() {
        return this.generateParams(false);
    }

    private String generateParamsWithTypes() {
        return this.generateParams(true);
    }

    private String generateParams(boolean withTypes) {
        String code = "";
        try {
            IParameter[] iParameterArray = this.method.getParameters();
            int n = iParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParameter parameter = iParameterArray[n2];
                if (withTypes && parameter.getType() != null) {
                    code = String.valueOf(code) + parameter.getType();
                }
                code = String.valueOf(code) + " ";
                code = String.valueOf(code) + parameter.getName();
                if (parameter.getDefaultValue() != null) {
                    code = String.valueOf(code) + "=" + parameter.getDefaultValue();
                }
                code = String.valueOf(code) + ",";
                ++n2;
            }
            if (code.length() > 0) {
                code = code.substring(0, code.length() - 1);
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return code;
    }

    private String generateBody() {
        String body = "";
        body = "{ " + this.lineDelimiter + "// TODO Auto-generated method stub " + this.lineDelimiter;
        try {
            if (this.method.isConstructor()) {
                body = String.valueOf(body) + "parent::__construct(" + this.generateParamsWithoutTypes() + ");" + this.lineDelimiter;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        body = String.valueOf(body) + "}" + this.lineDelimiter;
        return body;
    }

    private String generateAccess() {
        String access = new String();
        try {
            if (PHPFlags.isPublic((int)this.method.getFlags())) {
                access = "public";
            } else if (PHPFlags.isProtected((int)this.method.getFlags())) {
                access = "protected";
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return access;
    }

    private String generateComments() {
        String comment = "";
        if (this.generateComments) {
            try {
                comment = CodeGeneration.getMethodComment((IScriptProject)this.scriptProject, null, (String)this.method.getElementName(), null, null, null, (IMethod)this.method, (String)this.lineDelimiter, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return comment;
    }

    public String toString() {
        try {
            this.generateCode();
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.code;
    }

    public static String getMethodStub(String parent, IMethod method, IMethod overridden, String indent, String lineDelim, boolean comments) throws ModelException {
        StringBuilder buffer = new StringBuilder();
        String comment = null;
        if (comments) {
            try {
                comment = CodeGeneration.getMethodComment((IMethod)method, (IMethod)overridden, (String)lineDelim);
                comment = MethodStub.indentPattern(String.valueOf(lineDelim) + comment, indent, lineDelim);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (comments && comment != null) {
            buffer.append(comment);
        }
        String modifier = "public";
        try {
            if (PHPFlags.isPrivate((int)method.getFlags())) {
                modifier = "private";
            } else if (PHPFlags.isProtected((int)method.getFlags())) {
                modifier = "protected";
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        String signatureIndent = comments ? "" : indent;
        buffer.append(String.valueOf(signatureIndent) + modifier + " function ");
        String methodName = method.isConstructor() ? parent : method.getElementName();
        buffer.append(methodName);
        buffer.append("(");
        int i = 0;
        int size = method.getParameters().length;
        IParameter[] iParameterArray = method.getParameters();
        int n = iParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameter param = iParameterArray[n2];
            if (PDTModelUtils.isValidType((String)param.getType(), (IScriptProject)method.getScriptProject())) {
                buffer.append(String.valueOf(param.getType()) + " ");
            }
            buffer.append(param.getName());
            if (param.getDefaultValue() != null) {
                if ("array".equals(param.getType()) && param.getDefaultValue().trim().length() == 0) {
                    buffer.append(" = array()");
                } else {
                    buffer.append(" = " + param.getDefaultValue());
                }
            }
            if (i++ < size - 1) {
                buffer.append(", ");
            }
            ++n2;
        }
        buffer.append(") {");
        buffer.append(lineDelim);
        buffer.append(String.valueOf(indent) + indent + "// TODO: Auto-generated method stub");
        buffer.append(lineDelim);
        buffer.append(lineDelim);
        buffer.append(String.valueOf(indent) + "}");
        buffer.append(lineDelim);
        return buffer.toString();
    }

    private static String indentPattern(String originalPattern, String indentation, String lineDelim) {
        String delimPlusIndent = String.valueOf(lineDelim) + indentation;
        String indentedPattern = String.valueOf(originalPattern.replaceAll(lineDelim, delimPlusIndent)) + delimPlusIndent;
        return indentedPattern;
    }
}

