/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ui.contentassist;

import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ITextEditor;
import org.pdtextensions.core.log.Logger;
import org.pdtextensions.core.ui.codemanipulation.MethodStub;
import org.pdtextensions.core.util.PDTFormatterUtils;

public class SuperclassMethodCompletionProposal
extends PHPCompletionProposal {
    private final IMethod method;
    private boolean replacementComputed = false;

    public SuperclassMethodCompletionProposal(String replacementString, int replacementOffset, int replacementLength, final Image image, String displayString, int relevance, IMethod iMethod, ISourceModule iSourceModule) {
        super(replacementString, replacementOffset, replacementLength, (Supplier)new Supplier<Image>(){

            @Override
            public Image get() {
                return image;
            }
        }, new StyledString(displayString), relevance);
        this.method = iMethod;
    }

    public String getReplacementString() {
        if (!this.replacementComputed) {
            return this.computeReplacementString();
        }
        return super.getReplacementString();
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        IModelElement modelElement = ((PHPStructuredEditor)((PHPStructuredTextViewer)viewer).getTextEditor()).getModelElement();
        try {
            int off = viewer.getDocument().getLineInformationOfOffset(this.getReplacementOffset()).getOffset();
            Region region = new Region(off, this.getReplacementString().length() + (offset - off));
            PDTFormatterUtils.format((IDocument)viewer.getDocument(), (IRegion)region, (IProject)modelElement.getScriptProject().getProject());
            ISourceModule module = (ISourceModule)modelElement.getAncestor(ISourceModule.class);
            module.makeConsistent(null);
            IModelElement elementAt = module.getElementAt(offset);
            ISourceRange sourceRange = (elementAt instanceof IType ? ((IType)elementAt).getMethod(this.method.getElementName()) : (IMethod)elementAt).getSourceRange();
            String string = viewer.getDocument().get(sourceRange.getOffset(), sourceRange.getLength());
            int pos = string.indexOf(123) + 1;
            while (Character.isWhitespace(string.charAt(pos))) {
                ++pos;
            }
            viewer.getDocument().getLineInformationOfOffset(sourceRange.getOffset() + pos);
            this.setCursorPosition(sourceRange.getOffset() - this.getReplacementOffset() + pos);
        }
        catch (BadLocationException e) {
            Logger.logException((Throwable)e);
        }
        catch (ModelException e) {
            Logger.logException((Throwable)e);
        }
    }

    private String computeReplacementString() {
        ITextViewer viewer = this.getTextViewer();
        IDocument document = viewer.getDocument();
        ITextEditor textEditor = ((PHPStructuredTextViewer)viewer).getTextEditor();
        try {
            IModelElement editorElement;
            if (textEditor instanceof PHPStructuredEditor && (editorElement = ((PHPStructuredEditor)textEditor).getModelElement()) != null) {
                char indentChar = FormatterUtils.getFormatterCommonPreferences().getIndentationChar(document);
                String indent = String.valueOf(indentChar);
                String code = "";
                code = String.valueOf(code) + MethodStub.getMethodStub(this.method.getElementName(), this.method, this.method, indent, TextUtilities.getDefaultLineDelimiter((IDocument)document), true);
                return code;
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        return "";
    }
}

