/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.ast.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Block;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.pdtextensions.core.ast.util.GenericVisitor;

public class BlockContainsFinder
extends GenericVisitor {
    private Block fStartNode;
    private ASTNode[] fToSearch;
    private int fIndex;
    private Match fMatch;
    private ASTMatcher fMatcher;
    private List<Match> fResult;

    public BlockContainsFinder(Block coveringNode, ASTNode[] toSearchIsomorphic) {
        Assert.isNotNull((Object)coveringNode);
        Assert.isLegal((toSearchIsomorphic.length > 0 ? 1 : 0) != 0);
        this.fStartNode = coveringNode;
        this.fToSearch = toSearchIsomorphic;
    }

    public void perform() {
        this.fResult = new ArrayList<Match>();
        this.fMatcher = new ASTMatcher();
        this.reset();
        this.fStartNode.accept((Visitor)this);
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        if (this.matches(node)) {
            return false;
        }
        if (!this.isResetted()) {
            this.reset();
            if (this.matches(node)) {
                return false;
            }
        }
        return true;
    }

    private boolean isResetted() {
        return this.fIndex == 0 && this.fMatch.isEmpty();
    }

    private boolean matches(ASTNode node) {
        if (this.fToSearch[this.fIndex].subtreeMatch(this.fMatcher, (Object)node)) {
            this.fMatch.add(node);
            ++this.fIndex;
            if (this.fIndex == this.fToSearch.length) {
                this.fResult.add(this.fMatch);
                this.reset();
            }
            return true;
        }
        return false;
    }

    private void reset() {
        this.fIndex = 0;
        this.fMatch = new Match();
    }

    public List<Match> getMatches() {
        return this.fResult;
    }

    public static class Match {
        private List<ASTNode> fNodes = new ArrayList<ASTNode>();

        public void add(ASTNode node) {
            this.fNodes.add(node);
        }

        public ASTNode[] getNodes() {
            return this.fNodes.toArray(new ASTNode[this.fNodes.size()]);
        }

        public boolean isEmpty() {
            return this.fNodes.isEmpty();
        }
    }
}

