/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.server.core.Server;
import org.pdtextensions.core.log.Logger;

public class LaunchConfigurationHelper {
    public static ILaunchConfiguration createLaunchConfiguration(IProject project, Server server, IFile file) throws CoreException {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
        if (!file.exists()) {
            Logger.debugMSG("File does not exist, cannot create launch configuration: " + file.toString());
            return null;
        }
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, project.getName());
        String debuggerID = PHPProjectPreferences.getDefaultDebuggerID((IProject)project);
        String URL2 = String.valueOf(server.getBaseURL()) + "/app_dev.php";
        AbstractDebuggerConfiguration debuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)debuggerID);
        wc.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, debuggerID);
        wc.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, debuggerConfiguration.getWebLaunchDelegateClass());
        wc.setAttribute("name", server.getName());
        wc.setAttribute("file_name", file.getFullPath().toOSString());
        wc.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        wc.setAttribute("org.eclipse.php.debug.core.OpenInBrowser", PHPDebugPlugin.getOpenInBrowserOption());
        wc.setAttribute("firstLineBreakpoint", false);
        wc.setAttribute("base_url", URL2);
        wc.setAttribute("auto_generated_url", false);
        return wc.doSave();
    }
}

