/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.launch;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.pdtextensions.core.exception.ExecutableNotFoundException;
import org.pdtextensions.core.launch.ScriptLauncher;
import org.pdtextensions.core.launch.ScriptLauncherInterface;
import org.pdtextensions.core.launch.ScriptNotFoundException;
import org.pdtextensions.core.launch.environment.Environment;
import org.pdtextensions.core.launch.environment.EnvironmentFactory;
import org.pdtextensions.core.log.Logger;

@Creatable
public class ScriptLauncherManager
implements ScriptLauncherInterface {
    private static final String LAUNCHER_ID = "org.pdtextensions.core.executableLauncher";
    private final HashMap<String, EnvironmentFactory> factories = new HashMap();

    @Inject
    public ScriptLauncherManager(IExtensionRegistry registry) {
        this.evaluate(registry);
    }

    private void evaluate(IExtensionRegistry registry) {
        try {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(LAUNCHER_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                EnvironmentFactory factory = (EnvironmentFactory)e.createExecutableExtension("class");
                if (factory != null) {
                    this.factories.put(e.getAttribute("id"), factory);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private Environment getEnvironment(String factoryId, IProject project) throws ExecutableNotFoundException {
        if (!this.factories.containsKey(factoryId)) {
            return null;
        }
        return this.factories.get(factoryId).getEnvironment(project);
    }

    @Override
    public ScriptLauncher getLauncher(String factoryId, IProject project) throws ScriptNotFoundException, ExecutableNotFoundException {
        Environment env = this.getEnvironment(factoryId, project);
        if (env == null) {
            throw new ExecutableNotFoundException("Can't find any executable");
        }
        return new ScriptLauncher(env, project);
    }

    @Override
    public void resetEnvironment() {
    }
}

