/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.core.util;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.format.DefaultCodeFormattingProcessor;
import org.eclipse.php.internal.core.format.ICodeFormattingProcessor;
import org.eclipse.php.internal.core.format.IFormatterProcessorFactory;
import org.eclipse.text.edits.TextEdit;
import org.pdtextensions.core.log.Logger;

public class PDTFormatterUtils {
    private static final String extensionName = "org.eclipse.php.ui.phpFormatterProcessor";
    private static IFormatterProcessorFactory formatterFactory;

    private static IFormatterProcessorFactory getFormatterFactory() {
        if (formatterFactory == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionName);
            int i = 0;
            while (i < elements.length) {
                final IConfigurationElement element = elements[i];
                if (element.getName().equals("processor")) {
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            Object object = element.createExecutableExtension("class");
                            if (object instanceof IFormatterProcessorFactory) {
                                formatterFactory = (IFormatterProcessorFactory)object;
                            }
                        }

                        public void handleException(Throwable exception) {
                            Logger.logException(exception);
                        }
                    });
                }
                ++i;
            }
        }
        return formatterFactory;
    }

    public static ICodeFormattingProcessor createCodeFormatter(IDocument document, IRegion region, PHPVersion phpVersion, boolean useASPTags, boolean useShortTags) throws Exception {
        if (PDTFormatterUtils.getFormatterFactory() != null) {
            return formatterFactory.getCodeFormattingProcessor(document, phpVersion, useASPTags, useShortTags, region);
        }
        return new DefaultCodeFormattingProcessor(new HashMap());
    }

    public static void format(IDocument document, IRegion region, IProject project) {
        DocumentChange documentChange = new DocumentChange("Format region", document);
        try {
            try {
                Change undoChange;
                ICodeFormattingProcessor formatter = PDTFormatterUtils.createCodeFormatter(document, region, ProjectOptions.getPHPVersion((IProject)project), ProjectOptions.isSupportingASPTags((IProject)project), ProjectOptions.useShortTags((IProject)project));
                documentChange.setEdit((TextEdit)formatter.getTextEdits());
                if (document != null) {
                    LinkedModeModel.closeAllModels((IDocument)document);
                }
                documentChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                RefactoringStatus valid = documentChange.isValid((IProgressMonitor)new NullProgressMonitor());
                if (valid.hasFatalError()) {
                    Status status = new Status(4, "org.eclipse.php.ui", 4, valid.getMessageMatchingSeverity(4), null);
                    throw new CoreException((IStatus)status);
                }
                IUndoManager manager = RefactoringCore.getUndoManager();
                boolean successful = false;
                try {
                    manager.aboutToPerformChange((Change)documentChange);
                    undoChange = documentChange.perform((IProgressMonitor)new NullProgressMonitor());
                    successful = true;
                }
                finally {
                    manager.changePerformed((Change)documentChange, successful);
                }
                if (undoChange != null) {
                    undoChange.initializeValidationData((IProgressMonitor)new NullProgressMonitor());
                    manager.addUndo("Undo formatting", undoChange);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
                if (documentChange != null) {
                    documentChange.dispose();
                }
            }
        }
        finally {
            if (documentChange != null) {
                documentChange.dispose();
            }
        }
    }
}

