/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.repos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.pdtextensions.repos.api.IDependency;
import org.pdtextensions.repos.api.IDownloadFileCallback;
import org.pdtextensions.repos.api.IDownloadStreamCallback;
import org.pdtextensions.repos.api.IModuleVersion;

public class ModuleVersion
implements IModuleVersion {
    private String moduleName;
    private String vendorName;
    private String name;
    private boolean isRelease;
    private Map<String, IFileDownload> files = new HashMap<String, IFileDownload>();
    private String primaryFile;
    private List<IDependency> dependencies;
    private List<IDependency> deepDependencies;
    private IDependencyLoader dependencyLoader;

    public ModuleVersion(String vendor, String module, String name, boolean isRelease, Map<String, IFile> files, String primaryFileName, IDependencyLoader depLoader) {
        this.moduleName = module;
        this.vendorName = vendor;
        this.name = name;
        this.isRelease = isRelease;
        this.files = new HashMap<String, IFileDownload>();
        for (Map.Entry<String, IFile> entry : files.entrySet()) {
            this.files.put(entry.getKey(), new FileWrapper(entry.getValue()));
        }
        this.primaryFile = primaryFileName;
        this.dependencyLoader = depLoader;
    }

    public ModuleVersion(String vendor, String module, String name, boolean isRelease, String primaryFileName, IFile primaryFile, IDependencyLoader depLoader) {
        this.moduleName = module;
        this.vendorName = vendor;
        this.isRelease = isRelease;
        this.files = new HashMap<String, IFileDownload>();
        if (primaryFileName != null) {
            this.files.put(primaryFileName, new FileWrapper(primaryFile));
        }
        this.primaryFile = primaryFileName;
        this.dependencyLoader = depLoader;
    }

    protected ModuleVersion(String vendor, String module, String name, boolean isRelease, IDependencyLoader depLoader) {
        this.moduleName = module;
        this.vendorName = vendor;
        this.name = name;
        this.isRelease = isRelease;
        this.dependencyLoader = depLoader;
    }

    protected Map<String, IFileDownload> loadFiles() throws CoreException {
        return null;
    }

    private void init() throws CoreException {
        if (this.files == null) {
            this.files = new HashMap<String, IFileDownload>();
            this.files = this.loadFiles();
            this.primaryFile = this.loadPrimaryFile();
        }
    }

    protected String loadPrimaryFile() throws CoreException {
        return null;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public String getVendorName() {
        return this.vendorName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRelease() {
        return this.isRelease;
    }

    @Override
    public boolean isDevelopment() {
        return !this.isRelease;
    }

    @Override
    public Iterable<String> getFiles(IProgressMonitor monitor) throws CoreException {
        this.init();
        return new ArrayList<String>(this.files.keySet());
    }

    @Override
    public String getPrimaryFile(IProgressMonitor monitor) throws CoreException {
        this.init();
        return this.primaryFile;
    }

    @Override
    public IFile download(String name, boolean useCache, IProgressMonitor monitor) throws CoreException {
        this.init();
        IFileDownload download = this.files.get(name);
        if (download != null) {
            return download.download(useCache, monitor);
        }
        return null;
    }

    @Override
    public InputStream openStream(String name, boolean useCache, IProgressMonitor monitor) throws CoreException {
        this.init();
        IFileDownload download = this.files.get(name);
        if (download != null) {
            return download.openStream(useCache, monitor);
        }
        return null;
    }

    @Override
    public Iterable<IDependency> getDependencies(boolean deep, IProgressMonitor monitor) throws CoreException {
        if (deep) {
            if (this.deepDependencies == null) {
                if (this.dependencyLoader == null) {
                    return Collections.EMPTY_LIST;
                }
                this.deepDependencies = this.dependencyLoader.loadDeepDependencies(monitor);
            }
            return Collections.unmodifiableList(this.deepDependencies);
        }
        if (this.dependencies == null) {
            if (this.dependencyLoader == null) {
                return Collections.EMPTY_LIST;
            }
            this.dependencies = this.dependencyLoader.loadDependencies(monitor);
        }
        return Collections.unmodifiableList(this.dependencies);
    }

    @Override
    public void downloadDependencies(boolean deep, boolean useCache, IProgressMonitor monitor, IDownloadFileCallback callback) throws CoreException {
        for (IDependency dep : this.getDependencies(deep, monitor)) {
            if (monitor.isCanceled()) {
                return;
            }
            callback.onDependency(dep.download(useCache, monitor), this, dep, monitor);
        }
    }

    @Override
    public void openDependenciesStream(boolean deep, boolean useCache, IProgressMonitor monitor, IDownloadStreamCallback callback) throws CoreException {
        for (IDependency dep : this.getDependencies(deep, monitor)) {
            if (monitor.isCanceled()) {
                return;
            }
            callback.onDependency(dep.openStream(useCache, monitor), this, dep, monitor);
        }
    }

    public static final class FileWrapper
    implements IFileDownload {
        private IFile file;

        public FileWrapper(IFile file) {
            this.file = file;
        }

        @Override
        public IFile download(boolean useCache, IProgressMonitor monitor) throws CoreException {
            return this.file;
        }

        @Override
        public InputStream openStream(boolean useCache, IProgressMonitor monitor) throws CoreException {
            return this.file.getContents();
        }
    }

    public static interface IDependencyLoader {
        public List<IDependency> loadDependencies(IProgressMonitor var1) throws CoreException;

        public List<IDependency> loadDeepDependencies(IProgressMonitor var1) throws CoreException;
    }

    public static interface IFileDownload {
        public IFile download(boolean var1, IProgressMonitor var2) throws CoreException;

        public InputStream openStream(boolean var1, IProgressMonitor var2) throws CoreException;
    }
}

