/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.repos.internal.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.pdtextensions.repos.internal.storage.Provider;

public class RepositoryStorage {
    private static RepositoryStorage INSTANCE;
    private int nextId;
    private List<Provider> providers = new ArrayList<Provider>();

    private RepositoryStorage() {
        String[] names;
        IEclipsePreferences preferences = this.getPrefs();
        this.nextId = preferences.getInt("nextid", 0);
        String[] stringArray = names = preferences.get("names", "").split(":");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.length() == 0) {
                Preferences node = preferences.node(id);
                String type = node.get("type", null);
                String uri = node.get("uri", null);
                this.providers.add(new Provider(id, type, uri));
            }
            ++n2;
        }
    }

    public static RepositoryStorage instance() {
        if (INSTANCE == null) {
            INSTANCE = new RepositoryStorage();
        }
        return INSTANCE;
    }

    public String getNextId() {
        ++this.nextId;
        IEclipsePreferences preferences = this.getPrefs();
        preferences.putInt("nextId", this.nextId);
        return "persist-repository-" + this.nextId;
    }

    private IEclipsePreferences getPrefs() {
        return ConfigurationScope.INSTANCE.getNode("org.pdtextensions.repos");
    }

    public void addProvider(String id, String type, String uri) {
        IEclipsePreferences preferences = this.getPrefs();
        Preferences node = preferences.node(id);
        node.put("type", type);
        node.put("uri", uri);
        this.providers.add(new Provider(id, type, uri));
    }

    public void removeProvider(String id) {
        for (Provider provider : this.providers) {
            if (!provider.getId().equals(id)) continue;
            this.providers.remove(provider);
            break;
        }
        IEclipsePreferences preferences = this.getPrefs();
        try {
            preferences.node(id).removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public Iterable<Provider> providers() {
        return Collections.unmodifiableList(this.providers);
    }
}

