/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.repos.internal.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.pdtextensions.repos.FindResult;
import org.pdtextensions.repos.PEXReposPlugin;
import org.pdtextensions.repos.api.IFindResult;
import org.pdtextensions.repos.api.IModule;
import org.pdtextensions.repos.api.IModuleVersion;
import org.pdtextensions.repos.api.IRepositoryProvider;
import org.pdtextensions.repos.api.IRepositoryProviderFactory;
import org.pdtextensions.repos.internal.debug.DebugProvider;
import org.pdtextensions.repos.internal.storage.Provider;
import org.pdtextensions.repos.internal.storage.RepositoryStorage;

public class GlobalRepositoryProvider
implements IRepositoryProvider {
    public static final String TYPE = "GLOBAL";
    private List<IRepositoryProvider> providers = new ArrayList<IRepositoryProvider>();

    public GlobalRepositoryProvider() {
        if (PEXReposPlugin.debug()) {
            this.providers.add(new DebugProvider());
        }
        for (IRepositoryProviderFactory factory : PEXReposPlugin.getFactories()) {
            for (IRepositoryProvider provider : factory.createDefaultRepositories()) {
                this.providers.add(provider);
            }
        }
        block2: for (Provider provider : RepositoryStorage.instance().providers()) {
            for (IRepositoryProviderFactory factory : PEXReposPlugin.getFactories()) {
                if (!factory.getType().equals(provider.getType())) continue;
                this.providers.add(factory.recoverPersistent(provider.getUri(), provider.getId()));
                continue block2;
            }
        }
    }

    @Override
    public Iterable<IModule> listModules(IProgressMonitor monitor) throws CoreException {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (IRepositoryProvider provider : this.providers) {
            if (monitor.isCanceled()) break;
            for (IModule module : provider.listModules(monitor)) {
                modules.add(module);
            }
        }
        return modules;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getId() {
        return TYPE;
    }

    public Iterable<IRepositoryProvider> getProviders() {
        return Collections.unmodifiableList(this.providers);
    }

    public void registerProvider(IRepositoryProvider provider) {
        if (TYPE.equals(provider.getType())) {
            throw new IllegalArgumentException("Cannot register global provider");
        }
        if ("DEBUG".equals(provider.getType())) {
            throw new IllegalArgumentException("Cannot register debug provider");
        }
        if (!provider.getId().startsWith("temp-")) {
            throw new IllegalArgumentException("You need to register temporary providers");
        }
        String id = RepositoryStorage.instance().getNextId();
        for (IRepositoryProviderFactory factory : PEXReposPlugin.getFactories()) {
            if (!factory.getType().equals(provider.getType())) continue;
            factory.persist(provider, id);
            break;
        }
        if (!provider.getId().equals(id)) {
            return;
        }
        RepositoryStorage.instance().addProvider(id, provider.getType(), provider.getUri());
    }

    public void unregisterProvider(IRepositoryProvider provider) {
        RepositoryStorage.instance().removeProvider(provider.getId());
    }

    @Override
    public IFindResult findModule(String vendor, String name, String version, IProgressMonitor monitor) {
        ArrayList<IModuleVersion> versions = new ArrayList<IModuleVersion>();
        for (IRepositoryProvider provider : this.providers) {
            if (monitor.isCanceled()) break;
            IFindResult result = provider.findModule(vendor, name, version, monitor);
            if (!result.isOk()) {
                return result;
            }
            for (IModuleVersion v : result.moduleVersions()) {
                versions.add(v);
            }
        }
        return new FindResult(Status.OK_STATUS, versions);
    }

    @Override
    public String getUri() {
        return TYPE;
    }

    @Override
    public boolean supportsDependencies() {
        return true;
    }
}

