/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.semanticanalysis.ui.contentassist;

import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.UseStatementInjector;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.pdtextensions.core.log.Logger;

public class InjectUseStatementCompletionProposal
extends PHPCompletionProposal {
    private IType type = null;

    public InjectUseStatementCompletionProposal(String replacementString, int replacementOffset, int replacementLength, final Image image, String displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, (Supplier)new Supplier<Image>(){

            @Override
            public Image get() {
                return image;
            }
        }, new StyledString(displayString), relevance);
    }

    public Image getImage() {
        return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.imp_obj.png");
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        ISourceModule input;
        IModelElement editorElement;
        IDocument document = viewer.getDocument();
        PHPStructuredEditor textEditor = (PHPStructuredEditor)((PHPStructuredTextViewer)viewer).getTextEditor();
        if (textEditor instanceof PHPStructuredEditor && (editorElement = textEditor.getModelElement()) != null && (input = EditorUtility.getEditorInputModelElement((IEditorPart)textEditor, (boolean)false)) instanceof ICodeAssist) {
            try {
                int repOffset = this.getReplacementOffset();
                int length = this.getReplacementLength();
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)input.getScriptProject());
                String type = document.get(repOffset, length);
                Object[] types = PHPModelAccess.getDefault().findTypes(null, type, ISearchEngine.MatchRule.EXACT, 0, 0, scope, (IProgressMonitor)new NullProgressMonitor());
                if (types.length == 1) {
                    this.type = types[0];
                    UseStatementInjector injector = new UseStatementInjector((ScriptCompletionProposal)this);
                    injector.inject(document, viewer, offset);
                } else if (types.length > 1) {
                    Object[] result;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new TypeLabelProvider());
                    dialog.setElements(types);
                    if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
                        this.type = (IType)result[0];
                        UseStatementInjector injector = new UseStatementInjector((ScriptCompletionProposal)this);
                        injector.inject(document, viewer, offset);
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.logException((Throwable)e);
            }
        }
    }

    public IModelElement getModelElement() {
        return this.type;
    }

    private static class TypeLabelProvider
    extends LabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IType) {
                return ((IType)element).getFullyQualifiedName("\\");
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.class_obj.png");
        }
    }
}

