/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.semanticanalysis.ui.handlers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPHP;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;
import org.pdtextensions.core.launch.ScriptLauncher;
import org.pdtextensions.core.launch.ScriptLauncherManager;
import org.pdtextensions.core.launch.execution.ExecutionResponseAdapter;
import org.pdtextensions.core.launch.execution.ExecutionResponseListener;
import org.pdtextensions.core.log.Logger;
import org.pdtextensions.core.ui.PEXUIPlugin;
import org.pdtextensions.core.util.ArrayUtil;
import org.pdtextensions.semanticanalysis.ui.PEXAnalysisUIPlugin;
import org.pdtextensions.semanticanalysis.ui.preferences.PEXPreferenceNames;

public class RunPHPCSFixerHandler
extends AbstractHandler {
    private List<String> fixerArgs;
    @Inject
    protected ScriptLauncherManager launcherManager;

    public RunPHPCSFixerHandler() {
        ContextInjectionFactory.inject((Object)((Object)this), (IEclipseContext)PEXUIPlugin.getDefault().getEclipseContext());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection;
        IPreferenceStore store = PEXAnalysisUIPlugin.getDefault().getParentPreferenceStore();
        String defaultFixers = store.getString("phpcs_use_default_fixers");
        String config = store.getString("phpcs_config");
        this.fixerArgs = new ArrayList<String>();
        this.fixerArgs.add("file");
        if (!"phpcs_config_default".equals(config)) {
            this.fixerArgs.add(" --config=" + config.replace("phpcs_config_", ""));
        }
        if ("false".equals(defaultFixers)) {
            ArrayList<String> fixers = new ArrayList<String>();
            String[] stringArray = PEXPreferenceNames.getPHPCSFixerOptions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String optionValue;
                String key = stringArray[n2];
                String option = store.getString(key);
                if (option != null && option.length() > 0 && (optionValue = this.getOption(option)) != null) {
                    fixers.add(this.getOption(option));
                }
                ++n2;
            }
            this.fixerArgs.add(" --fixers=" + ArrayUtil.implode((String)",", (String[])fixers.toArray(new String[fixers.size()])));
        }
        if ((selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection()) != null && selection instanceof IStructuredSelection) {
            final IStructuredSelection strucSelection = (IStructuredSelection)selection;
            Job fixerJob = new Job("Running PHP-CS-Fixer"){

                protected IStatus run(IProgressMonitor monitor) {
                    Iterator iterator = strucSelection.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ElementImplForPHP impl;
                            Object element = iterator.next();
                            if (element instanceof IScriptFolder) {
                                IScriptFolder folder = (IScriptFolder)element;
                                RunPHPCSFixerHandler.this.processFolder(folder, monitor);
                                continue;
                            }
                            if (element instanceof ISourceModule) {
                                RunPHPCSFixerHandler.this.runFixer((ISourceModule)element, monitor);
                                continue;
                            }
                            if (!(element instanceof ElementImplForPHP) || !((impl = (ElementImplForPHP)element).getModelElement().getPrimaryElement() instanceof ISourceModule)) continue;
                            RunPHPCSFixerHandler.this.runFixer((ISourceModule)impl.getModelElement().getPrimaryElement(), monitor);
                        }
                        catch (Exception e) {
                            Logger.logException((Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            fixerJob.schedule();
        }
        return null;
    }

    protected void processFolder(IScriptFolder folder, IProgressMonitor monitor) throws IOException, InterruptedException, CoreException {
        try {
            IModelElement[] iModelElementArray = folder.getChildren();
            int n = iModelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                if (child instanceof IScriptFolder) {
                    this.processFolder((IScriptFolder)child, monitor);
                } else if (child instanceof ISourceModule) {
                    this.runFixer((ISourceModule)child, monitor);
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Logger.logException((Throwable)e);
        }
    }

    private void runFixer(ISourceModule source, IProgressMonitor monitor) throws IOException, InterruptedException, CoreException {
        IResource resource = source.getUnderlyingResource();
        String fileToFix = resource.getLocation().toOSString();
        this.fixerArgs.set(0, fileToFix);
        Logger.debug((String)("Running cs-fixer: " + this.fixerArgs.get(1)));
        monitor.setTaskName("Fixing " + this.fixerArgs.get(1));
        try {
            ScriptLauncher launcher = this.launcherManager.getLauncher("org.pdtextensions.semanticanalysis.fixerLauncherFactory", source.getScriptProject().getProject());
            launcher.addResponseListener((ExecutionResponseListener)new ExecutionResponseAdapter(){

                public void executionMessage(String message) {
                    System.err.println(message);
                }
            });
            launcher.launch("fix", this.fixerArgs.toArray(new String[this.fixerArgs.size()]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        source.getUnderlyingResource().refreshLocal(0, null);
    }

    protected String getOption(String packed) {
        String[] unpacked = packed.split("::");
        if (unpacked != null && unpacked.length == 4 && "true".equals(unpacked[3])) {
            return unpacked[1];
        }
        return null;
    }

    protected String getDefaultPhar() throws Exception {
        int length;
        IPath location = PEXAnalysisUIPlugin.getDefault().getStateLocation();
        IPath pharPath = location.append("phpcsfixer1.phar");
        File pharFile = pharPath.toFile();
        Logger.debug((String)("checking if phar is already unpacked " + pharPath.toOSString()));
        if (pharFile.exists()) {
            Logger.debug((String)"Phar unpacked, returning path");
            return pharFile.getAbsolutePath();
        }
        Logger.debug((String)"Phar not unpacked yet, resolving internal URL");
        Bundle bundle = Platform.getBundle((String)"org.pdtextensions.semanticanalysis.ui");
        InputStream stream = FileLocator.openStream((Bundle)bundle, (IPath)new Path("Resources/phpcsfixer/phpcsfixer.phar"), (boolean)false);
        if (stream == null) {
            Logger.log((int)4, (String)"Unable to open inputStream to built-in phar");
            return null;
        }
        FileOutputStream outStream = new FileOutputStream(pharFile);
        Logger.debug((String)("Unpacking built-in phar to " + pharFile.getAbsolutePath()));
        byte[] buffer = new byte[1024];
        while ((length = stream.read(buffer)) > 0) {
            outStream.write(buffer, 0, length);
        }
        stream.close();
        outStream.close();
        return pharFile.getAbsolutePath();
    }
}

