/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.semanticanalysis.ui.preferences.csfixer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IStringButtonAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringButtonDialogField;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pdtextensions.semanticanalysis.ui.preferences.csfixer.PHPCSFixerConfigurationBlock;

public class LibraryInputDialog
extends StatusDialog {
    public static final boolean WINDOWS = File.separatorChar == '\\';
    private final StringDialogField fNameDialogField;
    private final StringButtonDialogField fPathDialogField;
    private final List<String> fExistingNames;

    public LibraryInputDialog(Shell parent, PHPCSFixerConfigurationBlock.FixerPhar lib, List<PHPCSFixerConfigurationBlock.FixerPhar> existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList<String>(existingEntries.size());
        int i = 0;
        while (i < existingEntries.size()) {
            PHPCSFixerConfigurationBlock.FixerPhar curr = existingEntries.get(i);
            if (!curr.equals(lib)) {
                this.fExistingNames.add(curr.name);
            }
            ++i;
        }
        if (lib == null) {
            this.setTitle("New Library Path");
        } else {
            this.setTitle("Edit Library Path");
        }
        this.fPathDialogField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                DirectoryDialog dialog = new DirectoryDialog(LibraryInputDialog.this.getShell());
                dialog.setFilterPath(LibraryInputDialog.this.fPathDialogField.getText());
                dialog.setText("Select the library path");
                dialog.setMessage("Please select the path which represent the PEAR library.");
                String newPath = dialog.open();
                if (newPath != null) {
                    LibraryInputDialog.this.fPathDialogField.setText(newPath);
                    LibraryInputDialog.this.doValidation();
                }
            }
        });
        this.fPathDialogField.setLabelText("Path:");
        this.fPathDialogField.setButtonLabel("Browse...");
        this.fPathDialogField.setText(lib != null ? lib.path : "");
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText("Name:");
        LibraryStandardInputAdapter adapter = new LibraryStandardInputAdapter();
        this.fNameDialogField.setDialogFieldListener((IDialogFieldListener)adapter);
        this.fNameDialogField.setText(lib != null ? lib.name : "");
    }

    public PHPCSFixerConfigurationBlock.FixerPhar getResult() {
        PHPCSFixerConfigurationBlock.FixerPhar lib = new PHPCSFixerConfigurationBlock.FixerPhar();
        lib.name = this.fNameDialogField.getText().trim();
        lib.custom = true;
        lib.path = this.fPathDialogField.getText().trim();
        return lib;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        inner.setLayout((Layout)layout);
        this.fNameDialogField.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null));
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), (int)this.convertWidthInCharsToPixels(60));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        this.fPathDialogField.doFillIntoGrid(inner, 3);
        LibraryInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newName = this.fNameDialogField.getText();
        String newPath = this.fPathDialogField.getText();
        if (newPath.length() == 0) {
            status.setError("Enter PEAR path.");
        }
        if (newName.length() == 0 && newPath.length() > 0) {
            int lastIndex;
            int n = lastIndex = WINDOWS ? newPath.lastIndexOf("\\") : newPath.lastIndexOf("/");
            if (lastIndex > 0) {
                newName = newPath.substring(lastIndex + 1).replace(' ', '_');
                this.fNameDialogField.setText(newName);
            }
        }
        if (newName.length() == 0) {
            status.setError("Enter library name.");
        } else if (!Pattern.matches("^[a-zA-Z0-9_]+$", newName)) {
            status.setError("Name can only contain letters, numbers and underscores");
        } else if (this.fExistingNames.contains(newName)) {
            status.setError("An entry with the same name already exists");
        }
        this.updateStatus((IStatus)status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    private class LibraryStandardInputAdapter
    implements IDialogFieldListener {
        private LibraryStandardInputAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            LibraryInputDialog.this.doValidation();
        }
    }
}

