/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.semanticanalysis.ui.preferences.csfixer;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.util.Key;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.pdtextensions.core.ui.preferences.launcher.LauncherConfigurationBlock;
import org.pdtextensions.core.ui.preferences.launcher.LauncherKeyBag;
import org.pdtextensions.semanticanalysis.ui.preferences.PEXPreferenceNames;
import org.pdtextensions.semanticanalysis.ui.preferences.csfixer.LibraryInputDialog;

public class PHPCSFixerConfigurationBlock
extends LauncherConfigurationBlock {
    private static final Key PREF_PHPCS_PHAR_LOCATION = PHPCSFixerConfigurationBlock.getPEXKey("phpcs_phar_location");
    private static final Key PREF_PHPCS_PHAR_NAME = PHPCSFixerConfigurationBlock.getPEXKey("phpcs_phar_name");
    private static final Key PREF_PHPCS_CUSTOM_PHAR_LOCATIONS = PHPCSFixerConfigurationBlock.getPEXKey("phpcs_custom_phar_locations");
    private static final Key PREF_PHPCS_CUSTOM_PHAR_NAMES = PHPCSFixerConfigurationBlock.getPEXKey("phpcs_custom_custom_phar_names");
    private static final Key PREF_PHPCS_USE_DEFAULT_FIXERS = PHPCSFixerConfigurationBlock.getPEXKey("phpcs_use_default_fixers");
    private static final Key PREF_PHPCS_CONFIG = PHPCSFixerConfigurationBlock.getPEXKey("phpcs_config");
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final int IDX_DEFAULT = 4;
    private ListDialogField<FixerPhar> pharField;
    private CheckboxTableViewer fixerList;
    private List<FixerOption> fixerOptions = new ArrayList<FixerOption>();

    public PHPCSFixerConfigurationBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container, LauncherKeyBag keyBag) {
        super(context, project, container, keyBag);
        this.unpackFixerOptions();
        this.initPharList();
    }

    protected void initPharList() {
        PharListAdapter adapter = new PharListAdapter();
        PharLabelProvider provider = new PharLabelProvider();
        String[] stringArray = new String[6];
        stringArray[0] = "New...";
        stringArray[1] = "Edit...";
        stringArray[2] = "Remove";
        stringArray[4] = "Default";
        String[] buttons = stringArray;
        this.pharField = new ListDialogField(adapter, buttons, (ILabelProvider)provider);
        this.pharField.setDialogFieldListener(adapter);
        this.pharField.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{"Name", "Path"};
        this.pharField.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.pharField.setViewerSorter((ViewerComparator)new ViewerSorter());
        this.unpackPhars();
    }

    public void createExtraContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        content.setLayout((Layout)layout);
        this.createFixerOptions(content);
        this.createPharOptions(content);
    }

    protected void createPharOptions(Composite parent) {
        Composite pharContent = new Composite(parent, 0);
        PixelConverter conv = new PixelConverter((Control)pharContent);
        GridLayout pharListLayout = new GridLayout();
        pharListLayout.marginHeight = 2;
        pharListLayout.marginWidth = 0;
        pharListLayout.numColumns = 3;
        pharContent.setLayout((Layout)pharListLayout);
        Label pharLabel = new Label(pharContent, 0);
        pharLabel.setText("Phar used for running the cs-fixer");
        GridData labelData = new GridData(8);
        labelData.horizontalSpan = 3;
        pharLabel.setLayoutData((Object)labelData);
        GridData listData = new GridData(770);
        listData.widthHint = conv.convertWidthInCharsToPixels(50);
        listData.heightHint = conv.convertHeightInCharsToPixels(12);
        Control listControl = this.pharField.getListControl(pharContent);
        listControl.setLayoutData((Object)listData);
        Composite buttonsControl = this.pharField.getButtonBox(pharContent);
        buttonsControl.setLayoutData((Object)new GridData(258));
    }

    protected void createFixerOptions(Composite parent) {
        Composite fixerContent = new Composite(parent, 0);
        GridLayout fixerLayout = new GridLayout();
        fixerLayout.marginHeight = 10;
        fixerLayout.marginWidth = 0;
        fixerContent.setLayout((Layout)fixerLayout);
        Group fixerGroup = new Group(fixerContent, 0);
        fixerGroup.setLayout((Layout)new GridLayout());
        fixerGroup.setLayoutData((Object)new GridData(768));
        fixerGroup.setText("CodingStandard Fixer Configuration");
        this.addComboBox((Composite)fixerGroup, "Configuration", PREF_PHPCS_CONFIG, PEXPreferenceNames.getPHPCSFixerConfig(), PEXPreferenceNames.getPHPCSFixerConfigLabels(), 0);
        final Button defaultFixers = this.addCheckBox((Composite)fixerGroup, "Use default PHP-CS fixer options", PREF_PHPCS_USE_DEFAULT_FIXERS, new String[]{"yes", "no"}, 0);
        defaultFixers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPCSFixerConfigurationBlock.this.fixerList.getTable().setEnabled(!defaultFixers.getSelection());
            }
        });
        this.fixerList = CheckboxTableViewer.newCheckList((Composite)fixerGroup, (int)2048);
        this.fixerList.getTable().setLayoutData((Object)new GridData(1808));
        this.fixerList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fixerList.setLabelProvider((IBaseLabelProvider)new FixerOptionLabelProvider());
        this.fixerList.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                FixerOption option = (FixerOption)element;
                return "true".equals(option.active);
            }
        });
        this.fixerList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FixerOption option = (FixerOption)event.getElement();
                Boolean bool = new Boolean(event.getChecked());
                option.active = bool.toString();
                PHPCSFixerConfigurationBlock.this.setValue(PHPCSFixerConfigurationBlock.getPEXKey(option.internal), PHPCSFixerConfigurationBlock.this.packOption(option));
            }
        });
        this.fixerList.setInput((Object)this.fixerOptions.toArray());
        if ("yes".equals(this.getValue(PREF_PHPCS_USE_DEFAULT_FIXERS))) {
            this.fixerList.getTable().setEnabled(false);
        }
    }

    final boolean isDefaultPhar(FixerPhar lib) {
        return this.pharField.getIndexOfElement((Object)lib) == 0;
    }

    final boolean isInternalPhar(FixerPhar phar) {
        return phar.path == "";
    }

    protected final void updatePharModel(DialogField field) {
        if (field == this.pharField) {
            StringBuffer customLibs = new StringBuffer();
            StringBuffer customPaths = new StringBuffer();
            List list = this.pharField.getElements();
            int i = 0;
            while (i < list.size()) {
                FixerPhar elem = (FixerPhar)list.get(i);
                if (elem.custom) {
                    if (customLibs.length() > 0) {
                        customLibs.append(';');
                        customPaths.append(';');
                    }
                    customLibs.append(elem.name);
                    customPaths.append(elem.path);
                }
                ++i;
            }
            FixerPhar defaultLibrary = (FixerPhar)this.pharField.getElement(0);
            if (defaultLibrary != null) {
                this.setValue(PREF_PHPCS_PHAR_NAME, defaultLibrary.name);
                this.setValue(PREF_PHPCS_PHAR_LOCATION, defaultLibrary.path);
            }
            this.setValue(PREF_PHPCS_CUSTOM_PHAR_NAMES, customLibs.toString());
            this.setValue(PREF_PHPCS_CUSTOM_PHAR_LOCATIONS, customPaths.toString());
        }
    }

    private FixerOption unpackOption(String option) {
        if (option == null || option.indexOf("::") == -1) {
            return null;
        }
        String[] values = option.split("::");
        FixerOption opt = new FixerOption();
        opt.internal = values[0];
        opt.option = values[1];
        opt.name = values[2];
        opt.active = values[3];
        return opt;
    }

    private String packOption(FixerOption option) {
        return String.format("%s::%s::%s::%s", option.internal, option.option, option.name, option.active);
    }

    private void unpackFixerOptions() {
        String[] stringArray = PEXPreferenceNames.getPHPCSFixerOptions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            FixerOption option = this.unpackOption(this.getValue(PHPCSFixerConfigurationBlock.getPEXKey(key)));
            if (option != null) {
                this.fixerOptions.add(option);
            }
            ++n2;
        }
    }

    private void unpackPhars() {
        String defaultName = this.getValue(PREF_PHPCS_PHAR_NAME);
        FixerPhar defaultLibrary = null;
        String customStandardPrefs = this.getValue(PREF_PHPCS_CUSTOM_PHAR_NAMES);
        String[] customStandards = new String[]{};
        String[] customPaths = new String[]{};
        if (customStandardPrefs != null) {
            customStandards = this.getTokens(customStandardPrefs, ";");
            String customPathPrefs = this.getValue(PREF_PHPCS_CUSTOM_PHAR_LOCATIONS);
            customPaths = this.getTokens(customPathPrefs, ";");
        }
        ArrayList<FixerPhar> elements = new ArrayList<FixerPhar>(customStandards.length + 1);
        FixerPhar lib = new FixerPhar();
        lib.name = "<Internal>";
        lib.custom = false;
        lib.path = "";
        elements.add(lib);
        if (lib.name.equals(defaultName)) {
            defaultLibrary = lib;
        }
        int i = 0;
        while (i < customStandards.length) {
            lib = new FixerPhar();
            lib.name = customStandards[i].trim();
            lib.custom = true;
            lib.path = customPaths[i].trim();
            elements.add(lib);
            if (lib.name.equals(defaultName)) {
                defaultLibrary = lib;
            }
            ++i;
        }
        this.pharField.setElements(elements);
        if (defaultLibrary != null) {
            this.setToDefaultPhar(defaultLibrary);
        }
    }

    private void setToDefaultPhar(FixerPhar lib) {
        List elements = this.pharField.getElements();
        elements.remove(lib);
        elements.add(0, lib);
        this.pharField.setElements((Collection)elements);
        this.pharField.enableButton(4, false);
    }

    private void doStandardButtonPressed(int index) {
        FixerPhar edited = null;
        if (index != 0) {
            edited = (FixerPhar)this.pharField.getSelectedElements().get(0);
        }
        if (index == 0 || index == 1) {
            LibraryInputDialog dialog = new LibraryInputDialog(this.getShell(), edited, this.pharField.getElements());
            if (dialog.open() == 0) {
                if (edited != null) {
                    this.pharField.replaceElement((Object)edited, (Object)dialog.getResult());
                } else {
                    this.pharField.addElement((Object)dialog.getResult());
                }
            }
        } else if (index == 4) {
            this.setToDefaultPhar(edited);
        }
    }

    protected String getPluginId() {
        return "org.pdtextensions.semanticanalysis.ui";
    }

    protected void afterSave() {
    }

    protected void beforeSave() {
    }

    protected String getHeaderLabel() {
        return "Select the PHP executable to be used for running cs-fixer binaries.";
    }

    protected String getProjectChoiceLabel() {
        return "Download cs-fixer.phar per project";
    }

    protected String getGlobalChoiceLabel() {
        return "Use global cs-fixer";
    }

    protected String getScriptLabel() {
        return "CS-fixer binary";
    }

    protected String getButtonGroupLabel() {
        return "CS-fixer selection";
    }

    protected String getScriptFieldLabel() {
        return "Custom cs-fixer binary";
    }

    protected boolean validateScript(String text) {
        File file = new File(text);
        return file.exists();
    }

    protected static final Key getPEXKey(String key) {
        return PHPCSFixerConfigurationBlock.getKey((String)"org.pdtextensions.semanticanalysis", (String)key);
    }

    static class FixerOption {
        public String name;
        public String internal;
        public String option;
        public String active;

        FixerOption() {
        }

        public String toString() {
            return this.option;
        }
    }

    class FixerOptionLabelProvider
    implements ILabelProvider {
        FixerOptionLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((FixerOption)element).option;
        }
    }

    public static class FixerPhar {
        public String name;
        public boolean custom;
        public String path;

        public String toString() {
            return this.name;
        }
    }

    private class PharLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        private PharLabelProvider() {
        }

        public Font getFont(Object element) {
            if (PHPCSFixerConfigurationBlock.this.isDefaultPhar((FixerPhar)element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public String getColumnText(Object element, int columnIndex) {
            FixerPhar lib = (FixerPhar)element;
            if (columnIndex == 0) {
                String name = lib.name;
                if (PHPCSFixerConfigurationBlock.this.isDefaultPhar(lib)) {
                    name = MessageFormat.format("{0} (default)", name);
                }
                return name;
            }
            if (columnIndex == 1) {
                return lib.path;
            }
            return "";
        }
    }

    private class PharListAdapter<Object>
    implements IListAdapter<Object>,
    IDialogFieldListener {
        private PharListAdapter() {
        }

        public void customButtonPressed(ListDialogField<Object> field, int index) {
            PHPCSFixerConfigurationBlock.this.doStandardButtonPressed(index);
        }

        private boolean canEdit(List<Object> selectedElements) {
            return selectedElements.size() == 1 && !PHPCSFixerConfigurationBlock.this.isInternalPhar((FixerPhar)selectedElements.get(0));
        }

        private boolean canSetToDefault(List<Object> selectedElements) {
            return selectedElements.size() == 1 && !PHPCSFixerConfigurationBlock.this.isDefaultPhar((FixerPhar)selectedElements.get(0));
        }

        private boolean canRemove(List<Object> selectedElements) {
            int count = selectedElements.size();
            if (count == 0) {
                return false;
            }
            int i = 0;
            while (i < count) {
                if (PHPCSFixerConfigurationBlock.this.isInternalPhar((FixerPhar)selectedElements.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void selectionChanged(ListDialogField<Object> field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
            field.enableButton(4, this.canSetToDefault(selectedElements));
            field.enableButton(2, this.canRemove(selectedElements));
        }

        public void doubleClicked(ListDialogField<Object> field) {
            if (this.canEdit(field.getSelectedElements())) {
                PHPCSFixerConfigurationBlock.this.doStandardButtonPressed(1);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            PHPCSFixerConfigurationBlock.this.updatePharModel(field);
        }
    }
}

