/*
 * Decompiled with CFR 0.152.
 */
package org.pdtextensions.server.internal.web;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.service.prefs.BackingStoreException;
import org.pdtextensions.server.PEXServerPlugin;
import org.pdtextensions.server.internal.web.IWebProjectStorage;
import org.pdtextensions.server.internal.web.PlainPhpProjectStorage;
import org.pdtextensions.server.internal.web.SettingsPhpProjectStorage;
import org.pdtextensions.server.web.IPhpWebFolder;
import org.pdtextensions.server.web.IPhpWebProject;
import org.pdtextensions.server.web.IPhpWebProjectListener;

public class PhpWebProject
implements IPhpWebProject {
    private IProject project;
    private IWebProjectStorage storage;
    private List<IPhpWebProjectListener> listeners = new ArrayList<IPhpWebProjectListener>();

    public PhpWebProject(IProject project) {
        this.project = project;
    }

    @Override
    public IProject getEclipseProject() {
        return this.project;
    }

    @Override
    public IScriptProject getScriptProject() {
        return DLTKCore.create((IProject)this.project);
    }

    @Override
    public IFacetedProject getFacetedProject() {
        try {
            return ProjectFacetsManager.create((IProject)this.project);
        }
        catch (CoreException ex) {
            PEXServerPlugin.logError(ex);
            return null;
        }
    }

    private void init() {
        if (this.storage == null) {
            if (this.hasWebFacet()) {
                try {
                    this.storage = new SettingsPhpProjectStorage(this.project);
                }
                catch (BackingStoreException e) {
                    PEXServerPlugin.logError(e);
                    this.storage = new PlainPhpProjectStorage(this.project);
                }
            } else {
                this.storage = new PlainPhpProjectStorage(this.project);
            }
        }
    }

    @Override
    public IContainer getDefaultWebFolder() {
        this.init();
        return this.storage.getDefaultWebFolder();
    }

    @Override
    public boolean hasWebFacet() {
        IFacetedProject faceted = this.getFacetedProject();
        if (faceted != null) {
            IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"php.web.project");
            return faceted.hasProjectFacet(webFacet);
        }
        return false;
    }

    @Override
    public void activateWebFacet() throws CoreException {
        IFacetedProject faceted = this.getFacetedProject();
        if (faceted != null) {
            IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"php.web.project");
            if (faceted.hasProjectFacet(webFacet)) {
                return;
            }
            IProjectFacetVersion version = webFacet.getVersion("1.0");
            faceted.installProjectFacet(version, null, (IProgressMonitor)new NullProgressMonitor());
            try {
                this.storage = new SettingsPhpProjectStorage(this.project);
            }
            catch (BackingStoreException e) {
                throw new CoreException((IStatus)new Status(4, "org.pdtextensions.server", "Error reading preferences", (Throwable)e));
            }
        }
    }

    @Override
    public void setDefaultWebFolder(IContainer folder) throws CoreException {
        this.init();
        IContainer oldValue = this.getDefaultWebFolder();
        if (!oldValue.equals((Object)folder)) {
            this.storage.setDefaultWebFolder(folder);
        }
    }

    @Override
    public IPhpWebFolder[] getWebFolders() {
        this.init();
        return this.storage.getWebFolders();
    }

    @Override
    public IPhpWebFolder createWebFolder(IContainer folder, String pathName) throws CoreException {
        this.init();
        WebFolder result = new WebFolder(this.storage.createWebFolder(folder, pathName));
        for (IPhpWebProjectListener listener : this.listeners) {
            listener.onAddedWebFolder(this, result);
        }
        return result;
    }

    @Override
    public void removeWebFolder(IPhpWebFolder folder) throws CoreException {
        this.init();
        this.storage.removeWebFolder(((WebFolder)folder).folder);
        for (IPhpWebProjectListener listener : this.listeners) {
            listener.onRemovedFolder(this, folder);
        }
    }

    @Override
    public void registerProjectListener(IPhpWebProjectListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeProjectListener(IPhpWebProjectListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyProjectClosed() {
        for (IPhpWebProjectListener listener : this.listeners) {
            listener.onProjectClosed(this);
        }
    }

    public void notifySettingsChanged() {
        if (this.storage instanceof SettingsPhpProjectStorage) {
            try {
                ((SettingsPhpProjectStorage)this.storage).reload();
            }
            catch (BackingStoreException e) {
                PEXServerPlugin.logError(e);
            }
        }
    }

    private class WebFolder
    implements IPhpWebFolder {
        private IPhpWebFolder folder;

        public WebFolder(IPhpWebFolder folder) {
            this.folder = folder;
        }

        @Override
        public IContainer getFolder() {
            return this.folder.getFolder();
        }

        @Override
        public String getPathName() {
            return this.folder.getPathName();
        }

        @Override
        public void set(IContainer folder, String pathName) throws CoreException {
            IContainer oldFolder = this.folder.getFolder();
            String oldPath = this.folder.getPathName();
            this.folder.set(folder, pathName);
            for (IPhpWebProjectListener listener : PhpWebProject.this.listeners) {
                listener.onChangedFolder(PhpWebProject.this, this.folder, oldFolder, folder, oldPath, pathName);
            }
        }
    }
}

