/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.exec;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.eclipse.core.resources.IProject;
import si.gos.eclipse.exec.ExecutionResponseListener;
import si.gos.eclipse.internals.exec.Executor;

public class Launcher {
    protected IProject project;
    private Executor executor;
    private Set<ExecutionResponseListener> listeners = new HashSet<ExecutionResponseListener>();
    private Integer timeout = null;

    public Launcher() {
    }

    public Launcher(IProject project) {
        this.project = project;
    }

    public void addResponseListener(ExecutionResponseListener listener) {
        this.listeners.add(listener);
    }

    public void removeResponseListener(ExecutionResponseListener listener) {
        this.listeners.remove(listener);
    }

    public void launch(CommandLine cmd) throws ExecuteException, IOException, InterruptedException {
        this.executor = new Executor();
        if (this.timeout != null) {
            this.executor.setTimeout(this.timeout);
        }
        if (this.project != null) {
            this.executor.setWorkingDirectory(this.project.getLocation().toFile());
        }
        for (ExecutionResponseListener listener : this.listeners) {
            this.executor.addResponseListener(listener);
        }
        this.executor.execute(cmd);
    }

    public void abort() {
        this.executor.abort();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

