/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.forms;

import java.util.ArrayList;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import si.gos.eclipse.forms.IFormEntryListener;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.eclipse.widgets.utils.ToolkitFactory;

public class FormEntry {
    private Control label;
    private Text text;
    private Button browse;
    boolean ignoreModify = false;
    private ArrayList<IFormEntryListener> listeners = new ArrayList();
    public static final int DEFAULT_TEXT_WIDTH_HINT = 100;

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText) {
        this(parent, factory, labelText, null, false);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, int style) {
        this.createControl(parent, factory, labelText, style, null, false, 0, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, int style, boolean linkLabel) {
        this.createControl(parent, factory, labelText, style, null, linkLabel, 0, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, int indent, int colspan) {
        this(parent, factory, labelText, null, false, indent, colspan);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, String browseText) {
        this(parent, factory, labelText, browseText, false, 0, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, String browseText, int indent) {
        this(parent, factory, labelText, browseText, false, indent, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, String browseText, int indent, int colspan) {
        this(parent, factory, labelText, browseText, false, indent, colspan);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, boolean linkLabel) {
        this(parent, factory, labelText, null, linkLabel, 0, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, boolean linkLabel, int indent) {
        this(parent, factory, labelText, null, linkLabel, indent, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, boolean linkLabel, int indent, int colspan) {
        this(parent, factory, labelText, null, linkLabel, indent, colspan);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, String browseText, boolean linkLabel) {
        this(parent, factory, labelText, browseText, linkLabel, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, String browseText, boolean linkLabel, int indent) {
        this(parent, factory, labelText, browseText, linkLabel, indent, 0);
    }

    public FormEntry(Composite parent, IWidgetFactory factory, String labelText, String browseText, boolean linkLabel, int indent, int colspan) {
        this.createControl(parent, factory, labelText, 4, browseText, linkLabel, indent, colspan);
    }

    private void createControl(Composite parent, IWidgetFactory factory, String labelText, int style, String browseText, boolean linkLabel, int indent, int tcolspan) {
        if (linkLabel) {
            Hyperlink link = factory.createHyperlink(parent, labelText, 0);
            this.label = link;
        } else if (labelText != null) {
            this.label = factory.createLabel(parent, labelText);
            if (factory instanceof ToolkitFactory) {
                this.label.setForeground(((ToolkitFactory)factory).getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
            }
        }
        this.text = factory.createText(parent, "", style);
        this.addListeners();
        if (browseText != null) {
            this.browse = factory.createButton(parent, browseText, 8);
            this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (IFormEntryListener listener : FormEntry.this.listeners) {
                        listener.browseButtonSelected(FormEntry.this);
                    }
                }
            });
        }
        this.fillIntoGrid(parent, indent, tcolspan);
        this.setTextWidthHint(100);
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        if (this.label instanceof Hyperlink) {
            ((Hyperlink)this.label).setUnderlined(enabled);
        }
        if (this.browse != null) {
            this.browse.setEnabled(enabled);
        }
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
        if (this.label instanceof Hyperlink) {
            ((Hyperlink)this.label).setUnderlined(editable);
        }
        if (this.browse != null) {
            this.browse.setEnabled(editable);
        }
    }

    private void fillIntoGrid(Composite parent, int indent, int tcolspan) {
        Layout layout = parent.getLayout();
        if (layout instanceof GridLayout) {
            GridData gd;
            int tspan;
            int span = ((GridLayout)layout).numColumns;
            if (tcolspan > 0) {
                tspan = tcolspan;
            } else {
                int n = tspan = this.browse != null ? span - 2 : span - 1;
            }
            if (this.label != null) {
                gd = new GridData(4);
                gd.horizontalIndent = indent;
                this.label.setLayoutData((Object)gd);
            }
            gd = new GridData(256);
            gd.horizontalSpan = tspan;
            if (this.label != null) {
                gd.horizontalIndent = 3;
            }
            gd.grabExcessHorizontalSpace = tspan == 1;
            gd.widthHint = 10;
            this.text.setLayoutData((Object)gd);
            if (this.browse != null) {
                gd = new GridData(4);
                this.browse.setLayoutData((Object)gd);
            }
        } else if (layout instanceof TableWrapLayout) {
            TableWrapData td;
            int tspan;
            int span = ((TableWrapLayout)layout).numColumns;
            if (tcolspan > 0) {
                tspan = tcolspan;
            } else {
                int n = tspan = this.browse != null ? span - 2 : span - 1;
            }
            if (this.label != null) {
                td = new TableWrapData();
                td.valign = 32;
                td.indent = indent;
                this.label.setLayoutData((Object)td);
            }
            td = new TableWrapData(128);
            td.colspan = tspan;
            if (this.label != null) {
                td.indent = 3;
            }
            td.grabHorizontal = tspan == 1;
            td.valign = 32;
            this.text.setLayoutData((Object)td);
            if (this.browse != null) {
                td = new TableWrapData(128);
                td.valign = 32;
                this.browse.setLayoutData((Object)td);
            }
        }
    }

    public void addFormEntryListener(IFormEntryListener listener) {
        if (this.label != null && this.label instanceof Hyperlink) {
            ((Hyperlink)this.label).addHyperlinkListener((IHyperlinkListener)listener);
        }
        this.listeners.add(listener);
    }

    public void removeFormEntryListener(IFormEntryListener listener) {
        if (this.label != null && this.label instanceof Hyperlink) {
            ((Hyperlink)this.label).removeHyperlinkListener((IHyperlinkListener)listener);
        }
        this.listeners.remove(listener);
    }

    private void addListeners() {
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FormEntry.this.ignoreModify) {
                    for (IFormEntryListener listener : FormEntry.this.listeners) {
                        listener.textValueChanged(FormEntry.this);
                    }
                }
            }
        });
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FormEntry.this.text.selectAll();
                for (IFormEntryListener listener : FormEntry.this.listeners) {
                    listener.focusGained(FormEntry.this);
                }
            }

            public void focusLost(FocusEvent e) {
                for (IFormEntryListener listener : FormEntry.this.listeners) {
                    listener.focusLost(FormEntry.this);
                }
            }
        });
    }

    public Text getText() {
        return this.text;
    }

    public Control getLabel() {
        return this.label;
    }

    public Button getButton() {
        return this.browse;
    }

    public String getValue() {
        if (this.text != null && !this.text.isDisposed()) {
            return this.text.getText().trim();
        }
        return null;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (this.text != null && !this.text.isDisposed() && value != null && !value.equalsIgnoreCase(this.getValue())) {
            this.text.setText(value);
        }
    }

    public void setValue(String value, boolean blockNotification) {
        this.ignoreModify = blockNotification;
        this.setValue(value);
        this.ignoreModify = false;
    }

    public void setVisible(boolean visible) {
        if (this.label != null) {
            this.label.setVisible(visible);
        }
        if (this.text != null) {
            this.text.setVisible(visible);
        }
        if (this.browse != null) {
            this.browse.setVisible(visible);
        }
    }

    public void setTextWidthHint(int width) {
        Object data = this.getText().getLayoutData();
        if (data == null) {
            return;
        }
        if (data instanceof GridData) {
            ((GridData)data).widthHint = width;
        } else if (data instanceof TableWrapData) {
            ((TableWrapData)data).maxWidth = width;
        }
    }
}

