/*
 * Decompiled with CFR 0.152.
 */
package si.gos.eclipse.internals.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import si.gos.eclipse.exec.ExecutionResponseListener;

public class Executor {
    private DefaultExecutor executor;
    private ExecuteWatchdog watchdog;
    private PumpStreamHandler streamHandler;
    private LogOutputStream outStream;
    private LogOutputStream errStream;
    private StringBuilder outBuilder;
    private StringBuilder errBuilder;
    private int timeout = 60000;
    private Set<ExecutionResponseListener> listeners = new HashSet<ExecutionResponseListener>();
    private DefaultExecuteResultHandler handler = new DefaultExecuteResultHandler(){

        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            for (ExecutionResponseListener handler : Executor.this.listeners) {
                handler.executionFinished(Executor.this.outBuilder.toString(), exitValue);
            }
        }

        public void onProcessFailed(ExecuteException e) {
            String response = Executor.this.errBuilder.toString();
            String stdOutResponse = Executor.this.outBuilder.toString();
            super.onProcessFailed(e);
            for (ExecutionResponseListener handler : Executor.this.listeners) {
                if (stdOutResponse.length() > 0) {
                    response = stdOutResponse;
                }
                handler.executionFailed(response, (Exception)e);
            }
        }
    };

    public Executor() {
        this.outBuilder = new StringBuilder();
        this.errBuilder = new StringBuilder();
        this.errStream = new LogOutputStream(){

            protected void processLine(String line, int level) {
                if (!line.isEmpty()) {
                    Executor.this.errBuilder.append(String.valueOf(line) + "\n");
                    for (ExecutionResponseListener listener : Executor.this.listeners) {
                        listener.executionMessage(line);
                    }
                }
            }
        };
        this.outStream = new LogOutputStream(){

            protected void processLine(String line, int level) {
                if (!line.isEmpty()) {
                    Executor.this.outBuilder.append(String.valueOf(line) + "\n");
                    for (ExecutionResponseListener listener : Executor.this.listeners) {
                        listener.executionMessage(line);
                    }
                }
            }
        };
        this.streamHandler = new PumpStreamHandler((OutputStream)this.outStream, (OutputStream)this.errStream);
        this.executor = new DefaultExecutor();
        this.executor.setStreamHandler((ExecuteStreamHandler)this.streamHandler);
    }

    public void addResponseListener(ExecutionResponseListener listener) {
        this.listeners.add(listener);
    }

    public void removeResponseListener(ExecutionResponseListener listener) {
        this.listeners.remove(listener);
    }

    public void setTimeout(long timeout) {
        this.watchdog = new ExecuteWatchdog(timeout);
        this.executor.setWatchdog(this.watchdog);
    }

    public void setExitValue(int exitValue) {
        this.executor.setExitValue(exitValue);
    }

    public void execute(String cmd) throws ExecuteException, IOException, InterruptedException {
        this.execute(CommandLine.parse((String)cmd));
    }

    /*
     * Unable to fully structure code
     */
    public void execute(CommandLine cmd) {
        block5: {
            try {
                for (ExecutionResponseListener handler : this.listeners) {
                    handler.executionAboutToStart();
                }
                this.executor.setExitValue(0);
                this.executor.execute(cmd, (ExecuteResultHandler)this.handler);
                for (ExecutionResponseListener handler : this.listeners) {
                    handler.executionStarted();
                }
                this.handler.waitFor();
                break block5;
            }
            catch (Exception e) {
                ** for (handler : this.listeners)
            }
lbl-1000:
            // 1 sources

            {
                handler.executionFailed("", e);
                continue;
            }
        }
    }

    public void abort() {
        if (this.watchdog != null) {
            int[] nArray = new int[2];
            nArray[1] = 143;
            this.executor.setExitValues(nArray);
            this.watchdog.destroyProcess();
        }
    }

    public void setWorkingDirectory(File dir) {
        this.executor.setWorkingDirectory(dir);
    }

    public File getWorkingDirectory() {
        return this.executor.getWorkingDirectory();
    }

    public void setTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        this.timeout = timeout;
        this.watchdog = new ExecuteWatchdog((long)timeout);
        this.executor.setWatchdog(this.watchdog);
    }

    public int getTimeout() {
        return this.timeout;
    }
}

