/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.core.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import si.gos.eclipse.exec.ExecutionResponseListener;
import si.gos.eclipse.exec.Launcher;
import si.gos.transpiler.core.builder.ConsoleResponseHandler;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.core.model.ResourceLocator;
import si.gos.transpiler.core.model.TranspileItem;
import si.gos.transpiler.core.transpiler.InstalledTranspiler;

public class TranspilerBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "si.gos.transpiler.builder.TranspilerBuilder";
    private Map<String, TranspileItem> cache = new HashMap<String, TranspileItem>();

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (!project.hasNature("si.gos.transpiler.nature")) {
            return null;
        }
        Launcher launcher = new Launcher(project);
        launcher.addResponseListener((ExecutionResponseListener)new ConsoleResponseHandler());
        IResourceDelta delta = this.getDelta(project);
        if (delta != null) {
            ResourceLocator locator = new ResourceLocator(project);
            this.searchAndTranspile(delta.getAffectedChildren(), locator, launcher);
            project.refreshLocal(2, monitor);
        }
        return null;
    }

    private void searchAndTranspile(IResourceDelta[] affectedChildren, ResourceLocator locator, Launcher launcher) {
        IResourceDelta[] iResourceDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta affected = iResourceDeltaArray[n2];
            IPath path = affected.getProjectRelativePath();
            if (affected.getResource() instanceof IFile) {
                TranspileItem transpileItem = null;
                transpileItem = locator.getTranspileItem(path);
                if (transpileItem != null) {
                    this.transpile(transpileItem, launcher);
                }
            }
            this.searchAndTranspile(affected.getAffectedChildren(), locator, launcher);
            ++n2;
        }
    }

    private void transpile(TranspileItem transpileItem, Launcher launcher) {
        ConfiguredTranspiler ct = transpileItem.getConfiguredTranspiler();
        InstalledTranspiler itp = transpileItem.getInstalledTranspiler();
        String source = transpileItem.getSource().toOSString();
        String dest = transpileItem.getDestination().toOSString();
        String path = itp.getPath().toString();
        HashMap<String, String> subs = new HashMap<String, String>();
        subs.put("source", source);
        subs.put("destination", dest);
        CommandLine cmd = itp.getTranspiler().getCommand(path, ct.getOptions());
        cmd.setSubstitutionMap(subs);
        try {
            launcher.launch(cmd);
        }
        catch (ExecuteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void updateCache(ResourceLocator locator) {
        IProject project = locator.getProject();
        for (String cacheKey : this.cache.keySet()) {
            IPath path = project.findMember(cacheKey).getProjectRelativePath();
            TranspileItem item = locator.getTranspileItem(path);
            if (item != null) continue;
            this.cache.remove(cacheKey);
        }
    }
}

