/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.core.transpiler;

import si.gos.transpiler.core.transpiler.ITranspiler;

public class InstalledTranspiler {
    private String name;
    private String id;
    private String sourceExtension;
    private String destinationExtension;
    private String path;
    private String cmd;
    private String transpilerId;
    private ITranspiler transpiler;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.buildId();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public ITranspiler getTranspiler() {
        return this.transpiler;
    }

    public void setTranspiler(ITranspiler transpiler) {
        this.transpiler = transpiler;
        this.setTranspilerId(transpiler.getId());
    }

    public String getTranspilerId() {
        return this.transpilerId;
    }

    public void setTranspilerId(String transpilerId) {
        this.transpilerId = transpilerId;
        this.buildId();
    }

    private void buildId() {
        if (this.transpiler != null) {
            if (this.transpiler.isGeneric()) {
                this.setId(String.valueOf(this.transpilerId) + "_" + this.name.toLowerCase());
            } else {
                this.setId(this.transpilerId);
            }
        }
    }

    public String getSourceExtension() {
        return this.sourceExtension;
    }

    public void setSourceExtension(String extension) {
        this.sourceExtension = extension;
    }

    public String getDestinationExtension() {
        return this.destinationExtension;
    }

    public void setDestinationExtension(String destinationExtension) {
        this.destinationExtension = destinationExtension;
    }

    public static InstalledTranspiler fromTranspiler(ITranspiler transpiler) {
        InstalledTranspiler itp = new InstalledTranspiler();
        itp.setCmd(transpiler.getCmd());
        itp.setSourceExtension(transpiler.getSourceExtension());
        itp.setDestinationExtension(transpiler.getDestinationExtension());
        itp.setName(transpiler.getName());
        itp.setTranspiler(transpiler);
        return itp;
    }
}

