/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.controller;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import si.gos.transpiler.core.model.PathEntry;
import si.gos.transpiler.ui.TranspilerUIPluginImages;

public class PathEntryController
extends LabelProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    protected List<PathEntry> paths;
    private Image file = TranspilerUIPluginImages.FILE.createImage();
    private Image folder = TranspilerUIPluginImages.FOLDER.createImage();

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.paths = (List)newInput;
    }

    public Object[] getElements(Object inputElement) {
        return this.paths.toArray();
    }

    public int indexOf(PathEntry entry) {
        return this.paths.indexOf(entry);
    }

    public void add(PathEntry entry) {
        this.paths.add(entry);
    }

    public void remove(PathEntry entry) {
        this.paths.remove(entry);
    }

    public void update(int index, PathEntry entry) {
        this.paths.set(index, entry);
    }

    public String getText(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getProjectRelativePath().toString();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IFolder) {
            return this.folder;
        }
        if (element instanceof IFile) {
            return this.file;
        }
        return super.getImage(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getImage(((PathEntry)element).getSource());
            }
            case 1: {
                return this.getImage(((PathEntry)element).getDestination());
            }
        }
        return super.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getText(((PathEntry)element).getSource());
            }
            case 1: {
                return this.getText(((PathEntry)element).getDestination());
            }
        }
        return super.getText(element);
    }
}

