/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import si.gos.transpiler.core.TranspilerPlugin;
import si.gos.transpiler.core.transpiler.ITranspiler;
import si.gos.transpiler.core.transpiler.InstalledTranspiler;
import si.gos.transpiler.ui.controller.NonInstalledTranspilerController;
import si.gos.transpiler.ui.controller.TranspilerController;

public class InstalledTranspilerDialog
extends Dialog {
    private Text cmd;
    private Text path;
    private Text name;
    private boolean editing = false;
    private boolean fillingFromPreset = false;
    private InstalledTranspiler transpiler;
    private Text sourceExtension;
    private Text destinationExtension;

    protected InstalledTranspilerDialog(IShellProvider parentShell, InstalledTranspiler transpiler) {
        super(parentShell);
        this.transpiler = transpiler;
        this.editing = true;
    }

    public InstalledTranspilerDialog(Shell parentShell, InstalledTranspiler transpiler) {
        super(parentShell);
        this.transpiler = transpiler;
        this.editing = true;
    }

    protected InstalledTranspilerDialog(IShellProvider parentShell) {
        super(parentShell);
        this.transpiler = new InstalledTranspiler();
    }

    public InstalledTranspilerDialog(Shell parentShell) {
        super(parentShell);
        this.transpiler = new InstalledTranspiler();
    }

    protected Control createDialogArea(Composite parent) {
        Composite grid = new Composite(parent, 16);
        grid.setLayout((Layout)new GridLayout(2, false));
        grid.setLayoutData((Object)new GridData(1808));
        Label lblTranspilers = new Label(grid, 0);
        lblTranspilers.setText("Transpiler");
        TranspilerController controller = this.editing ? new TranspilerController() : new NonInstalledTranspilerController();
        ComboViewer comboViewer = new ComboViewer(grid, 8);
        Combo combo = comboViewer.getCombo();
        combo.setEnabled(!this.editing);
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.minimumWidth = 250;
        combo.setLayoutData((Object)gd_combo);
        comboViewer.setLabelProvider((IBaseLabelProvider)controller);
        comboViewer.setContentProvider((IContentProvider)controller);
        comboViewer.setInput((Object)TranspilerPlugin.getDefault().getTranspilerManager().getTranspilers());
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)event.getSelection()).getFirstElement();
                InstalledTranspilerDialog.this.setActiveTranspiler((ITranspiler)sel);
            }
        });
        if (this.editing) {
            combo.select(controller.indexOf(this.transpiler.getTranspiler()));
        }
        Label lblName = new Label(grid, 0);
        lblName.setText("Name");
        this.name = new Text(grid, 2048);
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstalledTranspilerDialog.this.transpiler.setName(InstalledTranspilerDialog.this.name.getText());
                if (!InstalledTranspilerDialog.this.fillingFromPreset) {
                    InstalledTranspilerDialog.this.name.setData("changed", (Object)true);
                }
            }
        });
        Label lblSourceExtension = new Label(grid, 0);
        lblSourceExtension.setText("Extension (Source)");
        this.sourceExtension = new Text(grid, 2048);
        this.sourceExtension.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.sourceExtension.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstalledTranspilerDialog.this.transpiler.setSourceExtension(InstalledTranspilerDialog.this.sourceExtension.getText());
            }
        });
        Label lblDestinationExtension = new Label(grid, 0);
        lblDestinationExtension.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDestinationExtension.setText("Extension (Destination)");
        this.destinationExtension = new Text(grid, 2048);
        this.destinationExtension.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.destinationExtension.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstalledTranspilerDialog.this.transpiler.setDestinationExtension(InstalledTranspilerDialog.this.destinationExtension.getText());
            }
        });
        Label lblPath = new Label(grid, 0);
        lblPath.setText("Executable");
        this.path = new Text(grid, 2048);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstalledTranspilerDialog.this.transpiler.setPath(InstalledTranspilerDialog.this.path.getText());
            }
        });
        Label lblCmd = new Label(grid, 0);
        lblCmd.setText("Cmd");
        this.cmd = new Text(grid, 2048);
        this.cmd.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InstalledTranspilerDialog.this.transpiler.setCmd(InstalledTranspilerDialog.this.cmd.getText());
            }
        });
        new Label(grid, 0);
        Label lblCmdDesc = new Label(grid, 0);
        lblCmdDesc.setText("Variables for use:\n\n$path - The path to the executable\n$options - Options to the executables\n$source - The source path\n$destination - The destination path");
        if (this.editing) {
            this.setActiveTranspiler(this.transpiler.getTranspiler());
        }
        return grid;
    }

    private void setActiveTranspiler(ITranspiler transpiler) {
        if (this.name.getData("changed") == null || !((Boolean)this.name.getData("changed")).booleanValue()) {
            this.fillingFromPreset = true;
            this.name.setText(transpiler.getName());
            this.fillingFromPreset = false;
        }
        if (this.transpiler != null && this.transpiler.getPath() != null) {
            this.path.setText(this.transpiler.getPath());
        }
        this.cmd.setText(transpiler.getCmd());
        this.sourceExtension.setText(transpiler.getSourceExtension());
        this.destinationExtension.setText(transpiler.getDestinationExtension());
        this.transpiler.setTranspiler(transpiler);
    }

    public InstalledTranspiler getInstalledTranspiler() {
        return this.transpiler;
    }
}

