/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import si.gos.eclipse.dialogs.ResourceFileSelectionDialog;
import si.gos.transpiler.core.model.PathEntry;
import si.gos.transpiler.ui.TranspilerUIPluginImages;
import si.gos.transpiler.ui.internal.filter.TypedViewerFilter;

public class PathDialog
extends Dialog {
    private Text source;
    private Text destFile;
    private Text destFolder;
    private Composite destRow;
    private Composite root;
    private IProject project;
    private PathEntry entry;
    private Image file = TranspilerUIPluginImages.FILE.createImage();
    private Image folder = TranspilerUIPluginImages.FOLDER.createImage();

    public PathDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        this.root = new Composite(parent, 16);
        this.root.setLayout((Layout)new GridLayout(2, false));
        Label lblSource = new Label(this.root, 0);
        lblSource.setText("Source");
        Composite sourceRow = new Composite(this.root, 0);
        GridData gd_sourceRow = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_sourceRow.widthHint = 350;
        sourceRow.setLayoutData((Object)gd_sourceRow);
        GridLayout gl_sourceRow = new GridLayout(3, false);
        gl_sourceRow.marginRight = -5;
        gl_sourceRow.marginBottom = -5;
        gl_sourceRow.marginTop = -4;
        gl_sourceRow.verticalSpacing = 0;
        gl_sourceRow.marginWidth = 0;
        gl_sourceRow.horizontalSpacing = 0;
        gl_sourceRow.marginHeight = 0;
        sourceRow.setLayout((Layout)gl_sourceRow);
        this.source = new Text(sourceRow, 2056);
        this.source.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button fileButton = new Button(sourceRow, 0);
        fileButton.setImage(this.file);
        fileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        fileButton.setText("File");
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFileSelectionDialog diag = PathDialog.this.createFileDialog("Source File Selection", PathDialog.this.entry.getSource());
                if (diag.open() == 0) {
                    PathDialog.this.setSource((IResource)((IFile)diag.getFirstResult()));
                }
            }
        });
        Button folderButton = new Button(sourceRow, 0);
        folderButton.setImage(this.folder);
        folderButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        folderButton.setText("Folder");
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog diag = PathDialog.this.createFolderDialog("Source Folder Selection", PathDialog.this.entry.getSource());
                if (diag.open() == 0) {
                    PathDialog.this.setSource((IResource)((IFolder)diag.getResult()[0]));
                }
            }
        });
        Label lblDestination = new Label(this.root, 0);
        lblDestination.setText("Destination");
        this.destRow = new Composite(this.root, 0);
        GridLayout gl_destRow = new GridLayout(1, false);
        gl_destRow.horizontalSpacing = 0;
        gl_destRow.marginRight = -5;
        gl_destRow.marginHeight = 0;
        gl_destRow.marginWidth = 0;
        gl_destRow.marginTop = -5;
        gl_destRow.verticalSpacing = 0;
        this.destRow.setLayout((Layout)gl_destRow);
        this.destRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPleaseSelectSource = new Label(this.destRow, 0);
        GridData gd_lblPleaseSelectSource = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_lblPleaseSelectSource.verticalIndent = 8;
        gd_lblPleaseSelectSource.heightHint = 17;
        lblPleaseSelectSource.setLayoutData((Object)gd_lblPleaseSelectSource);
        lblPleaseSelectSource.setText("Please select source first");
        if (this.entry != null) {
            this.setSource(this.entry.getSource());
            this.setDestination(this.entry.getDestination());
        } else {
            this.entry = new PathEntry();
        }
        return this.root;
    }

    private void setSource(IResource source) {
        if (source == null) {
            return;
        }
        this.entry.setSource(source);
        this.source.setText(source.getProjectRelativePath().toString());
        Control[] controlArray = this.destRow.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (source instanceof IFolder) {
            this.createFolderDestination();
        } else if (source instanceof IFile) {
            this.createFileDestination();
        }
        this.root.layout(true, true);
    }

    private void setDestination(IResource destination) {
        if (destination == null) {
            return;
        }
        this.entry.setDestination(destination);
        if (this.entry.getSource() instanceof IFolder) {
            this.destFolder.setText(destination.getProjectRelativePath().toString());
        } else {
            this.destFile.setText(destination.getProjectRelativePath().toString());
        }
    }

    private void createFileDestination() {
        Composite row = new Composite(this.destRow, 0);
        row.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_fileSource = new GridLayout(2, false);
        gl_fileSource.marginRight = -5;
        gl_fileSource.marginLeft = -5;
        row.setLayout((Layout)gl_fileSource);
        this.destFile = new Text(row, 2056);
        this.destFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button destFileButon = new Button(row, 0);
        destFileButon.setImage(this.file);
        destFileButon.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        destFileButon.setText("File");
        destFileButon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFileSelectionDialog diag = PathDialog.this.createFileDialog("Destination File Selection", PathDialog.this.entry.getDestination());
                if (diag.open() == 0) {
                    PathDialog.this.setDestination((IResource)((IFile)diag.getFirstResult()));
                }
            }
        });
    }

    private void createFolderDestination() {
        Composite row = new Composite(this.destRow, 0);
        row.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout gl_folderSource = new GridLayout(2, false);
        gl_folderSource.marginRight = -5;
        gl_folderSource.marginLeft = -5;
        row.setLayout((Layout)gl_folderSource);
        this.destFolder = new Text(row, 2056);
        this.destFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button destFolderButton = new Button(row, 0);
        destFolderButton.setImage(this.folder);
        destFolderButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        destFolderButton.setText("Folder");
        destFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog diag = PathDialog.this.createFolderDialog("Destination Folder Selection", PathDialog.this.entry.getDestination());
                if (diag.open() == 0) {
                    PathDialog.this.setDestination((IResource)((IFolder)diag.getFirstResult()));
                }
            }
        });
    }

    private ResourceFileSelectionDialog createFileDialog(String title, Object selection) {
        ResourceFileSelectionDialog diag = new ResourceFileSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        this.configureDialog((ElementTreeSelectionDialog)diag, title, "Select Folder", selection);
        return diag;
    }

    private ElementTreeSelectionDialog createFolderDialog(String title, Object selection) {
        ElementTreeSelectionDialog diag = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
        diag.addFilter((ViewerFilter)new TypedViewerFilter(new Class[]{IFolder.class}));
        this.configureDialog(diag, title, "Select Folder", selection);
        return diag;
    }

    private void configureDialog(ElementTreeSelectionDialog diag, String title, String message, Object selection) {
        diag.setTitle(title);
        diag.setMessage("Select Folder");
        diag.setAllowMultiple(false);
        diag.setHelpAvailable(false);
        diag.setInput((Object)this.project);
        if (selection != null) {
            diag.setInitialSelection(selection);
        }
    }

    public void setEntry(PathEntry entry) {
        this.entry = entry;
    }

    public PathEntry getEntry() {
        return this.entry;
    }
}

