/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.parts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import si.gos.eclipse.parts.CrudConfig;
import si.gos.eclipse.parts.TableCrudPart;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.transpiler.core.TranspilerPlugin;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.core.transpiler.ITranspilerManager;
import si.gos.transpiler.core.transpiler.InstalledTranspiler;
import si.gos.transpiler.ui.controller.ConfiguredTranspilerController;
import si.gos.transpiler.ui.controller.InstalledTranspilerController;

public class ConfiguredTranspilerPart
extends TableCrudPart {
    private TableViewer viewer;
    private IProject project;
    private ITranspilerManager manager = TranspilerPlugin.getDefault().getTranspilerManager();
    private ConfiguredTranspilerController controller = new ConfiguredTranspilerController();
    private Map<String, ConfiguredTranspiler> transpilers = new HashMap<String, ConfiguredTranspiler>();

    public ConfiguredTranspilerPart(IProject project) {
        super(new CrudConfig(){

            public boolean getEditVisible() {
                return false;
            }
        });
        this.project = project;
        this.transpilers = this.manager.getConfiguredTranspilers(project);
    }

    public void saveTranspilers() {
        this.manager.saveConfiguredTranspilers(this.project, this.transpilers);
    }

    protected StructuredViewer createStructuredViewer(Composite parent, IWidgetFactory factory) {
        this.viewer = (TableViewer)super.createStructuredViewer(parent, factory);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.controller);
        this.viewer.setContentProvider((IContentProvider)this.controller);
        this.viewer.setInput(this.transpilers);
        return this.viewer;
    }

    protected void handleAdd(IStructuredSelection selection) {
        ElementListSelectionDialog diag = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new InstalledTranspilerController());
        diag.setTitle("Select Installed Transpiler");
        diag.setElements(this.getInstalledTranspilers());
        if (diag.open() == 0) {
            this.addTranspiler((InstalledTranspiler)diag.getFirstResult());
            this.viewer.refresh();
        }
    }

    private Object[] getInstalledTranspilers() {
        ArrayList<InstalledTranspiler> itps = new ArrayList<InstalledTranspiler>();
        for (ConfiguredTranspiler ctp : this.transpilers.values()) {
            itps.add(ctp.getInstalledTranspiler());
        }
        ArrayList<InstalledTranspiler> elements = new ArrayList<InstalledTranspiler>();
        for (InstalledTranspiler itp : this.manager.getInstalledTranspilers().values()) {
            if (itps.contains(itp)) continue;
            elements.add(itp);
        }
        return elements.toArray();
    }

    protected void handleRemove(IStructuredSelection selection) {
        this.removeTranspiler((ConfiguredTranspiler)selection.getFirstElement());
        this.viewer.refresh();
    }

    private void addTranspiler(InstalledTranspiler itp) {
        ConfiguredTranspiler ctp = new ConfiguredTranspiler();
        ctp.setInstalledTranspiler(itp);
        this.transpilers.put(ctp.getId(), ctp);
    }

    private void removeTranspiler(ConfiguredTranspiler ctp) {
        this.transpilers.remove(ctp.getId());
    }
}

