/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.parts;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import si.gos.eclipse.actions.PartAction;
import si.gos.eclipse.parts.CrudConfig;
import si.gos.eclipse.parts.TableCrudPart;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.transpiler.core.TranspilerPlugin;
import si.gos.transpiler.core.transpiler.ITranspiler;
import si.gos.transpiler.core.transpiler.ITranspilerManager;
import si.gos.transpiler.core.transpiler.InstalledTranspiler;
import si.gos.transpiler.ui.controller.InstalledTranspilerController;
import si.gos.transpiler.ui.dialogs.InstalledTranspilerDialog;

public class InstallTranspilerPart
extends TableCrudPart {
    private TableViewer viewer;
    private ITranspilerManager manager = TranspilerPlugin.getDefault().getTranspilerManager();
    private InstalledTranspilerController controller = new InstalledTranspilerController();

    public InstallTranspilerPart() {
        super(new CrudConfig(){

            public String[] getActionLabels() {
                String[] labels = super.getActionLabels();
                String[] newLabels = new String[labels.length + 1];
                int i = 0;
                while (i < labels.length) {
                    newLabels[i] = labels[i];
                    ++i;
                }
                newLabels[3] = "Auto-Detect";
                return newLabels;
            }
        });
    }

    protected StructuredViewer createStructuredViewer(Composite parent, IWidgetFactory factory) {
        this.viewer = (TableViewer)super.createStructuredViewer(parent, factory);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.controller);
        this.viewer.setContentProvider((IContentProvider)this.controller);
        this.viewer.setInput((Object)this.manager.getInstalledTranspilers());
        return this.viewer;
    }

    protected void handleAdd(IStructuredSelection selection) {
        InstalledTranspilerDialog diag = new InstalledTranspilerDialog(this.getShell());
        if (diag.open() == 0) {
            this.manager.addInstalledTranspiler(diag.getInstalledTranspiler());
            this.viewer.refresh();
        }
    }

    protected void handleEdit(IStructuredSelection selection) {
        InstalledTranspiler transpiler = (InstalledTranspiler)selection.getFirstElement();
        InstalledTranspilerDialog diag = new InstalledTranspilerDialog(this.getShell(), transpiler);
        if (diag.open() == 0) {
            this.viewer.refresh();
        }
    }

    protected void handleRemove(IStructuredSelection selection) {
        InstalledTranspiler transpiler = (InstalledTranspiler)selection.getFirstElement();
        this.manager.removeInstalledTranspiler(transpiler);
        this.viewer.refresh();
    }

    private void autoDetect() {
        for (ITranspiler transpiler : this.manager.getTranspilers().values()) {
            InstalledTranspiler itp = transpiler.autoDetect();
            if (itp == null) continue;
            this.manager.addInstalledTranspiler(itp);
        }
        this.viewer.refresh();
    }

    protected void handleAction(PartAction action, int index) {
        super.handleAction(action, index);
        if (index == 3) {
            this.autoDetect();
        }
    }

    public void save() {
        this.manager.saveInstalledTranspilers();
    }
}

