/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import si.gos.eclipse.widgets.utils.WidgetHelper;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.core.transpiler.ITranspiler;
import si.gos.transpiler.core.transpiler.Option;

public class OptionsPart {
    private ConfiguredTranspiler confTranspiler;
    private ITranspiler transpiler;
    private Composite area;
    private List<Composite> rows;

    public OptionsPart(ConfiguredTranspiler configuredTranspiler) {
        this.transpiler = configuredTranspiler.getInstalledTranspiler().getTranspiler();
        this.confTranspiler = configuredTranspiler;
    }

    public Composite createContents(Composite parent) {
        this.area = new Composite(parent, 16);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        this.area.setLayout((Layout)layout);
        WidgetHelper.trim((Composite)this.area, (int)0);
        WidgetHelper.setSpacing((Composite)this.area, (int)0);
        WidgetHelper.setMargin((Composite)this.area, (int)0, (int)0);
        this.rows = new ArrayList<Composite>();
        for (Option o : this.transpiler.getOptions().values()) {
            this.rows.add(this.createRow(this.area, o));
        }
        return this.area;
    }

    private Composite createRow(Composite parent, final Option option) {
        boolean hasOption = this.confTranspiler.hasOption(option.getName());
        final Composite row = new Composite(parent, 16);
        row.setLayout((Layout)new RowLayout());
        RowData rd = new RowData();
        row.setLayoutData((Object)rd);
        WidgetHelper.trim((Composite)row, (int)0, (int)0, (int)5);
        WidgetHelper.setSpacing((Composite)row, (int)0);
        WidgetHelper.setMargin((Composite)row, (int)0, (int)0);
        final Button enabled = new Button(row, 32);
        row.setData("enabled", (Object)enabled);
        if (hasOption) {
            enabled.setSelection(true);
        }
        enabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (enabled.getSelection()) {
                    if (!OptionsPart.this.confTranspiler.hasOption(option.getName())) {
                        OptionsPart.this.confTranspiler.setOption(option.getName());
                    }
                } else {
                    OptionsPart.this.confTranspiler.removeOption(option.getName());
                }
            }
        });
        Composite right = new Composite(row, 16);
        RowLayout rlayout = new RowLayout();
        rlayout.type = 512;
        rlayout.wrap = true;
        right.setLayout((Layout)rlayout);
        WidgetHelper.trim((Composite)right, (int)0);
        WidgetHelper.setSpacing((Composite)right, (int)0, (int)0);
        WidgetHelper.setMargin((Composite)right, (int)0, (int)0);
        Composite top = new Composite(right, 16);
        RowLayout tlayout = new RowLayout();
        tlayout.justify = true;
        top.setLayout((Layout)tlayout);
        WidgetHelper.trim((Composite)top, (int)2, (int)0);
        WidgetHelper.setSpacing((Composite)top, (int)0);
        StringBuilder sb = new StringBuilder();
        if (option.getShort() != null && !option.getShort().isEmpty()) {
            sb.append("-");
            sb.append(option.getShort());
            sb.append(", ");
        }
        sb.append("--");
        sb.append(option.getName());
        if (option.getType().equals("param")) {
            sb.append("=");
        }
        final Label name = new Label(top, 0);
        name.setText(sb.toString());
        if (option.getType().equals("param") || option.getType().equals("enum")) {
            Text param = null;
            if (option.getType().equals("param")) {
                param = new Text(top, 4);
                if (hasOption) {
                    param.setText(this.confTranspiler.getOption(option.getName()));
                }
                param.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        OptionsPart.this.confTranspiler.setOption(option.getName(), ((Text)e.getSource()).getText());
                    }
                });
            } else if (option.getType().equals("enum")) {
                param = new Combo(top, 12);
                ((Combo)param).setItems(option.getValues());
                if (hasOption) {
                    ((Combo)param).setText(this.confTranspiler.getOption(option.getName()));
                }
                ((Combo)param).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        OptionsPart.this.confTranspiler.setOption(option.getName(), ((Combo)e.getSource()).getText());
                    }
                });
            }
            param.setLayoutData((Object)new RowData());
            row.setData("param", (Object)param);
        }
        if (!option.getDescription().isEmpty()) {
            Label description = new Label(right, 64);
            description.setText(option.getDescription());
            description.setLayoutData((Object)new RowData());
            row.setData("description", (Object)description);
        }
        row.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Object paramObj;
                int width = row.getSize().x;
                int left = enabled.getSize().x;
                Object descObj = row.getData("description");
                if (descObj != null) {
                    Label description = (Label)descObj;
                    RowData dd = (RowData)description.getLayoutData();
                    dd.width = width - left;
                }
                if ((paramObj = row.getData("param")) != null) {
                    Control param = (Control)paramObj;
                    RowData pd = (RowData)param.getLayoutData();
                    pd.width = width - left - name.getSize().x - 10;
                }
            }
        });
        return row;
    }

    public void setWidth(int width) {
        for (Composite row : this.rows) {
            RowData rd = (RowData)row.getLayoutData();
            rd.width = width;
        }
    }

    public ITranspiler getTranspiler() {
        return this.transpiler;
    }

    public void setTranspiler(ITranspiler transpiler) {
        this.transpiler = transpiler;
    }
}

