/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.parts;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import si.gos.eclipse.parts.TableCrudPart;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.core.model.PathEntry;
import si.gos.transpiler.ui.controller.PathEntryController;
import si.gos.transpiler.ui.dialogs.PathDialog;

public class PathEntryPart
extends TableCrudPart {
    private TableViewer viewer;
    private IProject project;
    private PathEntryController controller = new PathEntryController();
    private ConfiguredTranspiler transpiler;

    public PathEntryPart(IProject project) {
        this.project = project;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, IWidgetFactory factory) {
        this.viewer = (TableViewer)super.createStructuredViewer(parent, factory);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.controller);
        this.viewer.setContentProvider((IContentProvider)this.controller);
        if (this.transpiler != null) {
            this.viewer.setInput((Object)this.transpiler.getPaths());
        }
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn srcCol = new TableColumn(table, -1);
        srcCol.setText("Source");
        srcCol.setWidth(155);
        TableColumn destCol = new TableColumn(table, -1);
        destCol.setText("Destination");
        destCol.setWidth(155);
        return this.viewer;
    }

    public void setConfiguredTranspiler(ConfiguredTranspiler transpiler) {
        this.transpiler = transpiler;
        if (this.viewer != null) {
            if (transpiler == null) {
                this.viewer.setInput(null);
            } else {
                this.viewer.setInput((Object)transpiler.getPaths());
            }
        }
    }

    protected void handleAdd(IStructuredSelection selection) {
        PathDialog diag = new PathDialog(this.getShell(), this.project);
        if (diag.open() == 0) {
            PathEntry entry = diag.getEntry();
            if (entry.getSource() != null && entry.getDestination() != null) {
                entry.setConfiguredTranspiler(this.transpiler);
                this.controller.add(entry);
            }
            this.viewer.refresh();
        }
    }

    protected void handleEdit(IStructuredSelection selection) {
        PathDialog diag = new PathDialog(this.getShell(), this.project);
        PathEntry entry = (PathEntry)selection.getFirstElement();
        int index = this.controller.indexOf(entry);
        diag.setEntry(entry);
        if (diag.open() == 0) {
            entry = diag.getEntry();
            if (entry.getSource() != null && entry.getDestination() != null) {
                this.controller.update(index, diag.getEntry());
            } else {
                this.controller.remove(entry);
            }
            this.viewer.refresh();
        }
    }

    protected void handleRemove(IStructuredSelection selection) {
        PathEntry entry = (PathEntry)selection.getFirstElement();
        entry.setConfiguredTranspiler(null);
        this.controller.remove(entry);
        this.viewer.refresh();
    }
}

