/*
 * Decompiled with CFR 0.152.
 */
package si.gos.transpiler.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.dialogs.PropertyPage;
import si.gos.eclipse.widgets.utils.IWidgetFactory;
import si.gos.eclipse.widgets.utils.WidgetFactory;
import si.gos.eclipse.widgets.utils.WidgetHelper;
import si.gos.transpiler.core.model.ConfiguredTranspiler;
import si.gos.transpiler.ui.TranspilerUIPlugin;
import si.gos.transpiler.ui.parts.ConfiguredTranspilerPart;
import si.gos.transpiler.ui.parts.OptionsPart;
import si.gos.transpiler.ui.parts.PathEntryPart;

public class ProjectTranspilerPage
extends PropertyPage {
    public static final String ID = "si.gos.transpiler.ui.preferences.projectPropertyPage";
    private TabFolder tabFolder;
    private ConfiguredTranspilerPart configuredTranspilerPart;
    private PathEntryPart pathEntryPart;
    private ScrolledComposite optionContainer;
    private TabItem optionItem;
    private Composite page;
    private boolean resizing = false;
    private IProject project;

    public ProjectTranspilerPage() {
        ISelection sel;
        ISelectionService ss = TranspilerUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        Object selectedObject = sel = ss.getSelection();
        if (sel instanceof IStructuredSelection) {
            selectedObject = ((IStructuredSelection)sel).getFirstElement();
        }
        if (selectedObject instanceof IAdaptable) {
            IResource res = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class);
            this.project = res.getProject();
        }
    }

    protected Control createContents(Composite parent) {
        this.page = new Composite(parent, 16);
        this.page.setLayout((Layout)new GridLayout(1, false));
        WidgetHelper.setMargin((Composite)this.page, (int)0, (int)0);
        WidgetHelper.setSpacing((Composite)this.page, (int)0, (int)0);
        Composite left = new Composite(this.page, 0);
        left.setLayout((Layout)new GridLayout(2, false));
        GridData gd_left = new GridData(4, 4, true, true, 1, 1);
        gd_left.minimumWidth = 200;
        gd_left.minimumHeight = 80;
        gd_left.heightHint = 80;
        left.setLayoutData((Object)gd_left);
        WidgetFactory factory = new WidgetFactory();
        this.configuredTranspilerPart = new ConfiguredTranspilerPart(this.project);
        this.configuredTranspilerPart.createControl(left, (IWidgetFactory)factory);
        this.configuredTranspilerPart.addSelectionChangedListener(new ISelectionChangedListener(){
            private ConfiguredTranspiler lastSelection = null;

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection sel = (IStructuredSelection)e.getSelection();
                ProjectTranspilerPage.this.tabFolder.setEnabled(!sel.isEmpty());
                ProjectTranspilerPage.this.pathEntryPart.setEnabled(!sel.isEmpty());
                if (!sel.isEmpty()) {
                    ConfiguredTranspiler ct = (ConfiguredTranspiler)sel.getFirstElement();
                    if (ct != this.lastSelection) {
                        ProjectTranspilerPage.this.pathEntryPart.setConfiguredTranspiler(ct);
                        ProjectTranspilerPage.this.updateOptions(ct);
                        this.lastSelection = ct;
                    }
                } else {
                    ProjectTranspilerPage.this.pathEntryPart.setConfiguredTranspiler(null);
                    this.lastSelection = null;
                }
            }
        });
        Composite right = new Composite(this.page, 0);
        right.setLayout((Layout)new FillLayout(256));
        GridData gd_right = new GridData(4, 4, true, true, 1, 1);
        gd_right.minimumWidth = 440;
        gd_right.heightHint = 350;
        right.setLayoutData((Object)gd_right);
        this.tabFolder = new TabFolder(right, 0);
        this.tabFolder.setEnabled(false);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectTranspilerPage.this.tabFolder.getSelection()[0] == ProjectTranspilerPage.this.optionItem) {
                    ProjectTranspilerPage.this.optionContainer.layout(true, true);
                    ProjectTranspilerPage.this.resize();
                }
            }
        });
        TabItem tbtmPaths = new TabItem(this.tabFolder, 0);
        tbtmPaths.setText("Paths");
        Composite pathsContainer = new Composite((Composite)this.tabFolder, 0);
        pathsContainer.setLayout((Layout)new GridLayout(2, false));
        tbtmPaths.setControl((Control)pathsContainer);
        this.pathEntryPart = new PathEntryPart(this.project);
        this.pathEntryPart.createControl(pathsContainer, (IWidgetFactory)factory);
        this.pathEntryPart.setEnabled(false);
        this.optionItem = new TabItem(this.tabFolder, 0);
        this.optionItem.setText("Options");
        this.optionContainer = new ScrolledComposite((Composite)this.tabFolder, 768);
        this.optionContainer.setLayout((Layout)new GridLayout());
        this.optionContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.optionContainer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ProjectTranspilerPage.this.resize();
            }
        });
        this.optionItem.setControl((Control)this.optionContainer);
        return this.page;
    }

    private void resize() {
        if (!this.resizing) {
            this.resizing = true;
            Composite composite = (Composite)this.optionContainer.getContent();
            composite.setSize(composite.computeSize(this.optionContainer.getClientArea().width, -1));
            OptionsPart part = (OptionsPart)this.optionContainer.getData();
            part.setWidth(this.optionContainer.getClientArea().width);
            this.resizing = false;
        }
    }

    private void updateOptions(ConfiguredTranspiler ct) {
        Control[] controlArray = this.optionContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        OptionsPart part = new OptionsPart(ct);
        Composite composite = part.createContents((Composite)this.optionContainer);
        this.optionContainer.setContent((Control)composite);
        this.optionContainer.setData((Object)part);
        this.page.layout(true, true);
    }

    public boolean performOk() {
        this.configuredTranspilerPart.saveTranspilers();
        return true;
    }
}

